/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.af.commons.images.GraphDrawHelper;
import org.af.commons.images.GraphException;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.graph.EdgeWeight;
import org.af.gMCP.gui.graph.NetList;
import org.af.gMCP.gui.graph.Node;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Edge {
    private static final Log logger = LogFactory.getLog(Edge.class);
    public static Component panel = new JPanel();
    public boolean curve = false;
    FontRenderContext frc = null;
    Graphics2D g2d;
    int k1;
    int k2;
    public Node to;
    public Node from;
    public boolean fixed = false;
    public Color color = Color.BLACK;
    NetList nl;
    private EdgeWeight ew;
    int lastFontSize = 16;
    protected int x;
    protected int y;
    protected int w;
    protected int h;
    TeXIcon icon = null;

    public Edge(Node von, Node nach, Double w, NetList nl) {
        int x1 = von.getX() + Node.getRadius();
        int x2 = nach.getX() + Node.getRadius();
        int y1 = von.getY() + Node.getRadius();
        int y2 = nach.getY() + Node.getRadius();
        this.k1 = x1 + (x2 - x1) / 4;
        this.k2 = y1 + (y2 - y1) / 4;
        this.from = von;
        this.to = nach;
        this.ew = new EdgeWeight(w);
        this.nl = nl;
    }

    public static int[] getK(Node from, Node to, boolean curve) {
        int k2;
        int k1;
        int x1 = from.getX() + Node.getRadius();
        int x2 = to.getX() + Node.getRadius();
        int y1 = from.getY() + Node.getRadius();
        int y2 = to.getY() + Node.getRadius();
        if (curve) {
            double d = Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
            double y = y2 - y1;
            double x = x2 - x1;
            double alpha = x == 0.0 && y < 0.0 ? 90.0 : (x == 0.0 && y > 0.0 ? -90.0 : Math.atan(-y / x) / (Math.PI * 2) * 360.0 + (double)(x < 0.0 ? 180 : 0));
            k1 = x1 + (int)(Math.cos((alpha += 15.0) * (Math.PI * 2) / 360.0) * d / 2.0);
            k2 = y1 - (int)(Math.sin(alpha * (Math.PI * 2) / 360.0) * d / 2.0);
        } else if (Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)) > 200.0) {
            k1 = x1 + (x2 - x1) / 4;
            k2 = y1 + (y2 - y1) / 4;
        } else {
            k1 = x1 + (x2 - x1) / 2;
            k2 = y1 + (y2 - y1) / 2;
        }
        return new int[]{k1, k2};
    }

    public Edge(Node from, Node to, Double w, NetList nl, boolean curve) {
        this(from, to, w, nl);
        int[] k = Edge.getK(from, to, curve);
        this.k1 = k[0];
        this.k2 = k[1];
    }

    public Edge(Node von, Node nach, Double w, NetList nl, int k1, int k2) {
        this.from = von;
        this.to = nach;
        this.ew = new EdgeWeight(w);
        this.nl = nl;
        this.k1 = k1;
        this.k2 = k2;
    }

    public Edge(Node from, Node to, String wStr, NetList nl, boolean curve) {
        this(from, to, new EdgeWeight(wStr), nl, curve);
    }

    public Edge(Node from, Node to, String wStr, NetList nl, int i, int j) {
        this(from, to, new EdgeWeight(wStr), nl, i, j);
    }

    public Edge(Node from, Node to, EdgeWeight ew, NetList nl, int k1, int k2) {
        this(from, to, 0.0, nl, k1, k2);
        this.ew = ew;
    }

    public Edge(Node from, Node to, EdgeWeight ew, NetList nl, boolean curve) {
        this(from, to, 0.0, nl, curve);
        this.ew = ew;
    }

    public int getBendLeft() {
        double[] m;
        int x1 = this.from.getX() + Node.getRadius();
        int x2 = this.to.getX() + Node.getRadius();
        int y1 = this.from.getY() + Node.getRadius();
        int y2 = this.to.getY() + Node.getRadius();
        try {
            m = GraphDrawHelper.getCenter((double)x1, (double)y1, (double)this.k1, (double)this.k2, (double)x2, (double)y2);
        }
        catch (GraphException e) {
            return 0;
        }
        double[] phi = GraphDrawHelper.getAngle((double)x1, (double)y1, (double)this.k1, (double)this.k2, (double)x2, (double)y2, (double)m[0], (double)m[1]);
        double gamma = x1 - x2 == 0 ? (double)(90 + (y2 - y1 > 0 ? 0 : 180)) : Math.atan((-y1 + y2) / (x1 - x2)) * 360.0 / (Math.PI * 2) + (double)(x1 - x2 < 0 ? 180 : 0);
        return ((int)(phi[2] + (double)(phi[1] > 0.0 ? 180 : 0) + 90.0 - gamma) + 360) % 360;
    }

    public int getK1() {
        return this.k1;
    }

    public int getK2() {
        return this.k2;
    }

    public double getPos() {
        double[] m;
        int x1 = this.from.getX() + Node.getRadius();
        int x2 = this.to.getX() + Node.getRadius();
        int y1 = this.from.getY() + Node.getRadius();
        int y2 = this.to.getY() + Node.getRadius();
        try {
            m = GraphDrawHelper.getCenter((double)x1, (double)y1, (double)this.k1, (double)this.k2, (double)x2, (double)y2);
            double d = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
            double r = Math.sqrt((m[0] - (double)x1) * (m[0] - (double)x1) + (m[1] - (double)y1) * (m[1] - (double)y1));
            if (Math.PI * 2 * r / 360.0 > 6.0 * d / 200.0) {
                throw new GraphException("Edge is too linear.");
            }
        }
        catch (GraphException e) {
            double n2 = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
            double k = Math.sqrt((this.k1 - x1) * (this.k1 - x1) + (this.k2 - y1) * (this.k2 - y1));
            if (k > n2) {
                return 1.0;
            }
            return k / n2;
        }
        double[] phi = GraphDrawHelper.getAngle((double)x1, (double)y1, (double)this.k1, (double)this.k2, (double)x2, (double)y2, (double)m[0], (double)m[1]);
        double phiA = phi[2];
        double phiC = phi[3];
        double phiK = phi[4];
        double d = phi[1];
        int n = phi[0] == phi[2] ? 1 : -1;
        if (d * (double)n > 0.0) {
            if (phiK < phiA) {
                phiK += 360.0;
            }
            if (phiC < phiK) {
                phiC += 360.0;
            }
            return (phiK - phiA) / (phiC - phiA);
        }
        if (phiK > phiA) {
            phiK -= 360.0;
        }
        if (phiC > phiK) {
            phiC -= 360.0;
        }
        return (phiK - phiA) / (phiC - phiA);
    }

    String getWS() {
        return this.ew.toString();
    }

    public boolean inYou(int x2, int y2) {
        return x2 >= this.x && x2 <= this.x + this.w && y2 >= this.y && y2 <= this.y + this.h;
    }

    public int[] offset(int x2, int y2) {
        return new int[]{(int)((double)this.k1 * this.nl.getZoom()) - x2, (int)((double)this.k2 * this.nl.getZoom()) - y2};
    }

    public void paintEdge(Graphics g) {
        int x1 = this.from.x + Node.getRadius();
        int x2 = this.to.x + Node.getRadius();
        int y1 = this.from.y + Node.getRadius();
        int y2 = this.to.y + Node.getRadius();
        if (this.from != this.to) {
            int dx = x1 - this.k1;
            int dy = y1 - this.k2;
            double d = Math.sqrt(dx * dx + dy * dy);
            x1 -= (int)((double)(Node.getRadius() * dx) / d);
            y1 -= (int)((double)(Node.getRadius() * dy) / d);
            dx = this.k1 - x2;
            dy = this.k2 - y2;
            d = Math.sqrt(dx * dx + dy * dy);
            x2 += (int)((double)(Node.getRadius() * dx) / d);
            y2 += (int)((double)(Node.getRadius() * dy) / d);
            if (this.g2d == null) {
                this.g2d = (Graphics2D)g;
            }
            this.g2d = (Graphics2D)g;
            this.g2d.setColor(this.color);
            GraphDrawHelper.drawEdge((Graphics)g, (double)((int)((double)x1 * this.nl.getZoom())), (double)((int)((double)y1 * this.nl.getZoom())), (double)((int)((double)this.k1 * this.nl.getZoom())), (double)((int)((double)this.k2 * this.nl.getZoom())), (double)((int)((double)x2 * this.nl.getZoom())), (double)((int)((double)y2 * this.nl.getZoom())), (int)((int)(8.0 * this.nl.getZoom())), (int)35, (boolean)true);
            this.g2d.setColor(Color.BLACK);
        }
    }

    public void paintEdgeLabel(Graphics g) {
        this.g2d.setFont(new Font("Arial", 0, (int)(16.0 * this.nl.getZoom())));
        this.frc = this.g2d.getFontRenderContext();
        String s = this.getWS();
        if (!Configuration.getInstance().getGeneralConfig().useJLaTeXMath()) {
            Rectangle2D rc = this.g2d.getFont().getStringBounds(s, this.frc);
            this.g2d.setColor(new Color(0.99f, 0.99f, 0.99f));
            this.x = (int)((double)this.k1 * this.nl.getZoom() - rc.getWidth() / 2.0);
            this.y = (int)((double)this.k2 * this.nl.getZoom() - rc.getHeight() * 3.0 / 2.0);
            this.w = (int)(rc.getWidth() + 5.0);
            this.h = (int)(rc.getHeight() + 5.0);
            this.g2d.fillRect(this.x, this.y, this.w, this.h);
            this.g2d.setColor(Color.BLACK);
            Stroke oldStroke = this.g2d.getStroke();
            this.g2d.setStroke(new BasicStroke(1.0f));
            this.g2d.drawRect(this.x, this.y, this.w, this.h);
            this.g2d.setStroke(oldStroke);
            this.g2d.drawString(s, (float)((double)this.k1 * this.nl.getZoom() - rc.getWidth() / 2.0), (float)((double)this.k2 * this.nl.getZoom() - rc.getHeight() / 2.0));
        } else {
            if (this.icon == null || this.lastFontSize != (int)(16.0 * this.nl.getZoom())) {
                this.lastFontSize = (int)(16.0 * this.nl.getZoom());
                this.icon = Edge.getTeXIcon(this.nl.control.getGraphGUI(), s, this.lastFontSize);
            }
            this.g2d.setColor(new Color(0.99f, 0.99f, 0.99f));
            this.x = (int)((double)this.k1 * this.nl.getZoom() - (double)(this.icon.getIconWidth() / 2) - 5.0);
            this.y = (int)((double)this.k2 * this.nl.getZoom() - (double)(this.icon.getIconHeight() / 2) - 5.0);
            this.w = this.icon.getIconWidth() + 10;
            this.h = this.icon.getIconHeight() + 10;
            this.g2d.fillRect(this.x, this.y, this.w, this.h);
            this.g2d.setColor(Color.BLACK);
            Stroke oldStroke = this.g2d.getStroke();
            this.g2d.setStroke(new BasicStroke(1.0f));
            this.g2d.drawRect(this.x, this.y, this.w, this.h);
            this.g2d.setStroke(oldStroke);
            this.icon.paintIcon(panel, (Graphics)this.g2d, (int)((double)this.k1 * this.nl.getZoom() - (double)(this.icon.getIconWidth() / 2)), (int)((double)this.k2 * this.nl.getZoom() - (double)(this.icon.getIconHeight() / 2)));
        }
    }

    public static TeXIcon getTeXIcon(JFrame parent, String s, int points) {
        String latex = "";
        try {
            if (s.indexOf("E-") != -1) {
                latex = s.replaceAll("E-", "}{10^{");
                latex = "\\frac{" + latex + "}}";
            } else {
                int openBracket = 0;
                boolean waitingForDenominator = false;
                String nominator = "";
                s.replaceAll("\u03b5", "\\varepsilon");
                s.replaceAll(" ", "");
                for (int i = 0; i < s.length(); ++i) {
                    String c = "" + s.charAt(i);
                    if (c.equals("(")) {
                        ++openBracket;
                    }
                    if (c.equals(")")) {
                        --openBracket;
                    }
                    if ((c.equals("+") || c.equals("-") || c.equals("*") || c.equals(")") && i + 1 < s.length() && !(s.charAt(i + 1) + "").equals("/")) && openBracket == 0) {
                        String start = s.substring(0, i + 1);
                        if (waitingForDenominator) {
                            latex = c.equals(")") ? latex + "\\frac{" + nominator + "}{" + start + "}" : latex + "\\frac{" + nominator + "}{" + start.substring(0, i) + "}" + c;
                            waitingForDenominator = false;
                        } else {
                            latex = latex + start;
                        }
                        s = s.substring(i + 1, s.length());
                        i = -1;
                    }
                    if (!c.equals("/")) continue;
                    nominator = s.substring(0, i);
                    s = s.substring(i + 1, s.length());
                    i = -1;
                    waitingForDenominator = true;
                }
                latex = waitingForDenominator ? latex + "\\frac{" + nominator + "}{" + s + "}" : latex + s;
                latex = latex.replaceAll("\\*", Configuration.getInstance().getGeneralConfig().getTimesSymbol());
                latex = latex.replaceAll("\\(", "{(");
                latex = latex.replaceAll("\\)", ")}");
            }
            TeXFormula formula = new TeXFormula(latex);
            formula = new TeXFormula("\\mathbf{" + latex + "}");
            if (latex.indexOf("frac") == -1 && latex.length() > 4) {
                points = (int)((double)points * 0.7);
            }
            return formula.createTeXIcon(2, (float)points);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(parent, "Invalid weight string:\n" + latex + "\nError:\n" + e.getMessage(), "Invalid input", 0);
            TeXFormula formula = new TeXFormula("Syntax Error");
            return formula.createTeXIcon(2, (float)points);
        }
    }

    public void setK1(int k1) {
        double correction = 0.0;
        this.k1 = k1 + (int)correction;
        if (this.k1 < 0) {
            this.k1 = 0;
        }
    }

    public void setK2(int k2) {
        double correction = 0.0;
        if (this.frc != null) {
            Rectangle2D rc = this.g2d.getFont().getStringBounds(this.getWS(), this.frc);
            correction = rc.getHeight() / 2.0;
        }
        this.k2 = k2 + (int)correction;
        if (this.k2 < 0) {
            this.k2 = 0;
        }
    }

    public void setW(Double w) {
        this.ew = new EdgeWeight(w);
        this.icon = null;
        this.nl.repaint();
        this.nl.graphHasChanged();
    }

    public void setW(String text) {
        this.ew = new EdgeWeight(text);
        this.icon = null;
        this.nl.repaint();
        this.nl.graphHasChanged();
    }

    public String getWLaTeX() {
        return this.ew.getLaTeXStr();
    }

    public Collection<String> getVariable() {
        return this.ew.getVariables();
    }

    public double getW(Hashtable<String, Double> ht) {
        return this.ew.getWeight(ht);
    }

    public EdgeWeight getEdgeWeight() {
        return this.ew;
    }

    public String toString() {
        return "edge from " + this.from + " to " + this.to;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public boolean isCurved() {
        return this.curve;
    }

    public void move() {
        int[] k = Edge.getK(this.from, this.to, this.curve);
        this.k1 = k[0];
        this.k2 = k[1];
    }
}

