/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.options;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.af.commons.widgets.validate.ValidationException;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.options.OptionsPanel;

public class NumericPanel
extends OptionsPanel
implements ActionListener {
    private JCheckBox useEpsApprox;
    private JTextField jtfEps;
    private JCheckBox verbose;
    private Configuration conf;

    public NumericPanel(Configuration conf) {
        this.conf = conf;
        this.makeComponents();
        this.doTheLayout();
    }

    private void makeComponents() {
        this.useEpsApprox = new JCheckBox("Use epsilon approximation");
        this.useEpsApprox.setSelected(this.conf.getGeneralConfig().useEpsApprox());
        this.useEpsApprox.addActionListener(this);
        this.useEpsApprox.setEnabled(false);
        this.jtfEps = new JTextField(30);
        this.jtfEps.setText("" + this.conf.getGeneralConfig().getEpsilon());
        this.jtfEps.setEnabled(this.conf.getGeneralConfig().useEpsApprox());
        this.verbose = new JCheckBox("Verbose output of algorithms");
        this.verbose.setSelected(this.conf.getGeneralConfig().verbose());
    }

    private void doTheLayout() {
        JPanel p1 = new JPanel();
        String cols = "pref, 5dlu, fill:pref:grow";
        String rows = "pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref";
        FormLayout layout = new FormLayout(cols, rows);
        p1.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 1;
        p1.add((Component)this.useEpsApprox, cc.xyw(1, row, 3));
        p1.add((Component)new JLabel("Epsilon:"), cc.xy(1, row += 2));
        p1.add((Component)this.jtfEps, cc.xy(3, row));
        p1.add((Component)this.verbose, cc.xyw(1, row += 2, 3));
        this.add(p1);
    }

    public void setProperties() throws ValidationException {
        this.conf.getGeneralConfig().setVerbose(this.verbose.isSelected());
        this.conf.getGeneralConfig().setUseEpsApprox(this.useEpsApprox.isSelected());
        try {
            double eps = Double.parseDouble(this.jtfEps.getText());
            this.conf.getGeneralConfig().setEps(eps);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "\"" + this.jtfEps.getText() + "\" is not a valid double for epsilon.", "Invalid input", 0);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.useEpsApprox) {
            this.jtfEps.setEnabled(this.useEpsApprox.isSelected());
        }
    }
}

