% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{integerPoints}
\alias{integerPoints}
\title{Integer points inside an LP.}
\usage{
integerPoints(LP)
}
\arguments{
\item{LP}{The LP object defined using lpSolveAPI}
}
\value{
A data frame with all integer points inside the feasible region (columns x1, x2, lbl).
}
\description{
Integer points inside an LP.
}
\note{
Do a simple enumeration of all integer points between min and max.
}
\examples{
# Create the LP using lpSolveAPI package
LP <- make.lp(0, 2)
set.objfn(LP, c(7.75, 10))
add.constraint(LP, c(9, 10), "<=", 90)
add.constraint(LP, c(2, 4), "<=", 27)
add.constraint(LP, c(-3, 2), "<=", 3)
colNames <- c("x1", "x2")
colnames(LP) <- colNames
set.type(LP, c(1,2), type = "integer")

control <- lp.control(LP, sense='max')
cPoints<-cornerPoints(getA(LP), get.rhs(LP))
iPoints<-integerPoints(LP)

plotPolytope(cPoints, iPoints, iso = getC(LP), crit = substr(lp.control(LP)$sense,1,3))
}
\author{
Lars Relund \email{lars@relund.dk}
}

