% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotPlane3D}
\alias{plotPlane3D}
\title{Plot a plane in 3D.}
\usage{
plotPlane3D(
  normal,
  point = NULL,
  offset = 0,
  useShade = TRUE,
  useLines = FALSE,
  usePoints = FALSE,
  ...
)
}
\arguments{
\item{normal}{Normal to the plane.}

\item{point}{A point on the plane.}

\item{offset}{The offset of the plane (only used if \code{point = NULL}).}

\item{useShade}{Plot shade of the plane.}

\item{useLines}{Plot lines inside the plane.}

\item{usePoints}{Plot point shapes inside the plane.}

\item{...}{Further arguments passed on the the RGL plotting functions. This must be done as
lists (see examples). Currently the following arguments are supported:
\itemize{
\item \code{argsPlanes3d}: A list of arguments for \code{\link[rgl:planes]{rgl::planes3d()}} used when \code{useShade = TRUE}.
\item \code{argsLines}: A list of arguments for \code{\link[rgl:persp3d]{rgl::persp3d()}} when \code{useLines = TRUE}. Moreover, the list
may contain \code{lines}: number of lines.
}}
}
\value{
NULL (invisible)
}
\description{
Plot a plane in 3D.
}
\examples{
\donttest{
ini3D(argsPlot3d = list(xlim = c(-1,10), ylim = c(-1,10), zlim = c(-1,10)) )
plotPlane3D(c(1,1,1), point = c(1,1,1))
plotPoints3D(c(1,1,1))
plotPlane3D(c(1,2,1), point = c(2,2,2), argsPlanes3d = list(color="red"))
plotPoints3D(c(2,2,2))
plotPlane3D(c(2,1,1), offset = -6, argsPlanes3d = list(color="blue"))
plotPlane3D(c(2,1,1), argsPlanes3d = list(color="green"))
finalize3D()

ini3D(argsPlot3d = list(xlim = c(-1,10), ylim = c(-1,10), zlim = c(-1,10)) )
plotPlane3D(c(1,1,1), point = c(1,1,1), useLines = TRUE, useShade = TRUE)
ids <- plotPlane3D(c(1,2,1), point = c(2,2,2), argsLines = list(col="blue", lines = 100),
            useLines = TRUE)
finalize3D()
# pop3d(id = ids) # remove last plane
}
}
