% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-topoSort.R
\name{graph-toposort}
\alias{graph-toposort}
\alias{topoSort}
\alias{topoSort.default}
\alias{topoSortMAT}
\alias{topoSort_vparList}
\title{Topological sort of vertices in directed acyclic graph}
\usage{
topoSort(object, index = FALSE)

\method{topoSort}{default}(object, index = FALSE)

topoSortMAT(amat, index = FALSE)
}
\arguments{
\item{object}{An graph represented either as a \code{graphNEL}
object, an \code{igraph}, a (dense) \code{matrix}, a (sparse)
\code{dgCMatrix}.}

\item{index}{If FALSE, an ordering is returned if it exists and
\code{character(0)} otherwise. If TRUE, the index of the
variables in an adjacency matrix is returned and \code{-1}
otherwise.}

\item{amat}{Adjacency matrix.}
}
\value{
If FALSE, an ordering is returned if it exists and
    \code{character(0)} otherwise. If TRUE, the index of the
    variables in an adjacency matrix is returned and \code{-1}
    otherwise.
}
\description{
A topological ordering of a directed graph is a linear
    ordering of its vertices such that, for every edge (u->v), u
    comes before v in the ordering.  A topological ordering is
    possible if and only if the graph has no directed cycles, that
    is, if it is a directed acyclic graph (DAG). Any DAG has at
    least one topological ordering. Can hence be used for checking
    if a graph is a DAG.
}
\section{Note}{
 The workhorse is the \code{topoSortMAT} function
    which takes an adjacency matrix as input
}
\examples{

dagMAT  <- dag(~a:b:c+c:d:e, result="matrix")
dagMATS <- as(dagMAT, "dgCMatrix")
dagNEL  <- as(dagMAT, "graphNEL")

topoSort(dagMAT)
topoSort(dagMATS)
topoSort(dagNEL)

}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\seealso{
\code{\link{dag}}, \code{\link{ug}}
}
\keyword{utilities}

