% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-coerce-misc.R
\name{graph-coerce-misc}
\alias{graph-coerce-misc}
\alias{igraph2graphNEL}
\alias{graphNEL2adjMAT}
\alias{igraph2matrix}
\alias{igraph2dgCMatrix}
\alias{M2matrix}
\alias{M2dgCMatrix}
\alias{graphNEL2M}
\alias{as.adjMAT}
\alias{graphNEL2dgCMatrix}
\alias{graphNEL2matrix}
\alias{graphNEL2igraph}
\alias{graphNEL2ftM}
\alias{graphNEL2tfM}
\alias{M2igraph}
\alias{M2graphNEL}
\alias{glist2setMAT}
\title{Graph, matrix and generating class coercions}
\usage{
igraph2graphNEL(ig)

igraph2matrix(ig)

igraph2dgCMatrix(ig)

M2matrix(mat)

M2dgCMatrix(mat)

graphNEL2M(gn, result = "matrix")

as.adjMAT(gn, result = "matrix")

graphNEL2dgCMatrix(gn)

graphNEL2matrix(gn)

graphNEL2igraph(gn)

graphNEL2ftM(gn)

graphNEL2tfM(gn)

M2igraph(amat)

M2graphNEL(amat)

glist2setMAT(glist, vn = unique(unlist(glist)))
}
\arguments{
\item{ig}{igraph-object}

\item{mat}{Either a dense matrix or a sparse dgCMatrix.}

\item{gn}{A graphNEL object}

\item{result}{Either \code{"matrix"} or \code{"dgCMatrix"} (for a
sparse matrix representation)}

\item{amat}{Adjacency matrix}

\item{glist}{A list of generators where a generator is a character
vector. If interpreted as generators of an undirected graph, a
generator is a complete set of vertices in the graph. If
interpreted as generators of a dag, a generator (v1,...,vn)
means that there will be arrows from v2,...,vn to v1.}

\item{vn}{The names of the vertices in the graphs. These will be
the row and column names of the matrix}
}
\value{
An adjacency matrix (or \code{NULL} if \code{glist} has
    length 0)
}
\description{
Graph and matrix coercions where speed is an issue.
}
\details{
The igraph2something functions only serve to provide a
    uniform coercion interface; the functions are wrappers to
    \pkg{igraph} functions.
}
\examples{

glist <- list(1:3, 2:4, 4:5)
am1 <- ugList2M( glist )
am2 <- dagList2M( glist )
if (interactive() && require(Rgraphviz)){
  plot(as(am1, "graphNEL"))
  plot(as(am2, "graphNEL"))
}

## FIXME : This is a mess
m <- matrix(1:25, nrow=5)
M <- M2dgCMatrix(m)
m2 <- M2matrix(M)
M2 <- M2dgCMatrix(m2)

g <- ug(~ a:b + b:c)
graphNEL2M(g)
graphNEL2M(g, "dgCMatrix")


## Sparse and dense adjacency matrices converted to igraph
g1 <- ug(~a:b + b:c + c:d, result="matrix")
g2 <- ug(~a:b + b:c + c:d, result="dgCMatrix")
plot( M2igraph( g1 ) )
plot( M2igraph( g2 ) )


## Sparse and dense adjacency matrices converted to graphNEL
g1 <- ug(~a:b + b:c + c:d, result="matrix")
g2 <- ug(~a:b + b:c + c:d, result="dgCMatrix")
M2graphNEL( g1 )
M2graphNEL( g2 )

g <- list(c(1,2,3), c(2,3,4), c(4,5))
glist2setMAT(g)
}
\seealso{
\code{\link{ug}}, \code{\link{dag}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
