% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-mintriang.R
\name{graph-minimal_triang}
\alias{graph-minimal_triang}
\alias{minimal_triang}
\alias{minimal_triang.default}
\alias{minimal_triangMAT}
\title{Minimal triangulation of an undirected graph}
\usage{
minimal_triang(object, tobject = triangulate(object), result = NULL,
  details = 0)

\method{minimal_triang}{default}(object, tobject = triangulate(object),
  result = NULL, details = 0)

minimal_triangMAT(amat, tamat = triangulateMAT(amat), details = 0)
}
\arguments{
\item{object}{An undirected graph represented either as a \code{graphNEL}
object, a (dense) \code{matrix}, a (sparse) \code{dgCMatrix}.}

\item{tobject}{Any triangulation of \code{object}; must be of the same
representation.}

\item{result}{The type (representation) of the result. Possible values are
\code{"graphNEL"}, \code{"matrix"}, \code{"dgCMatrix"}. Default is the
same as the type of \code{object}.}

\item{details}{The amount of details to be printed.}

\item{amat}{The undirected graph which is to be triangulated; a symmetric
adjacency matrix.}

\item{tamat}{Any triangulation of \code{object}; a symmetric adjacency
matrix.}
}
\value{
\code{minimal_triang()} returns a graphNEL object while
    \code{minimal_triangMAT()} returns an adjacency matrix.
}
\description{
An undirected graph uG is triangulated (or chordal) if
    it has no cycles of length >= 4 without a chord which is
    equivalent to that the vertices can be given a perfect
    ordering. Any undirected graph can be triangulated by adding
    edges to the graph, so called fill-ins which gives the graph
    TuG.  A triangulation TuG is minimal if no fill-ins can be
    removed without breaking the property that TuG is triangulated.
}
\details{
For a given triangulation tobject it may be so that some
    of the fill-ins are superflous in the sense that they can be
    removed from tobject without breaking the property that tobject
    is triangulated. The graph obtained by doing so is a minimal
    triangulation.

    Notice: A related concept is the minimum
    triangulation, which is the the graph with the smallest number
    of fill-ins. The minimum triangulation is unique. Finding the
    minimum triangulation is NP-hard.
}
\examples{

## A graphNEL object
g1 <- ug(~a:b + b:c + c:d + d:e + e:f + a:f + b:e)
x <- minimal_triang(g1)

## g2 is a triangulation of g1 but it is not minimal
g2 <- ug(~a:b:e:f + b:c:d:e)
x <- minimal_triang(g1, tobject=g2)

## An adjacency matrix
g1m <- ug(~a:b + b:c + c:d + d:e + e:f + a:f + b:e, result="matrix")
x <- minimal_triangMAT(g1m)

}
\references{
Kristian G. Olesen and Anders L. Madsen (2002): Maximal Prime
    Subgraph Decomposition of Bayesian Networks. IEEE TRANSACTIONS ON
    SYSTEMS, MAN AND CYBERNETICS, PART B: CYBERNETICS, VOL. 32, NO. 1,
    FEBRUARY 2002
}
\seealso{
\code{\link{mpd}}, \code{\link{rip}}, \code{\link{triangulate}}
}
\author{
Clive Bowsher <C.Bowsher@statslab.cam.ac.uk> with modifications by
    Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
