% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_setops_obsolete.R
\name{set-operations-obsolete}
\alias{set-operations-obsolete}
\alias{maximal_sets_old}
\alias{minimal_sets_old}
\alias{remove_redundant_old}
\alias{is_inset_old}
\title{Suite of set operations}
\usage{
maximal_sets_old(setlist, index = FALSE)

minimal_sets_old(setlist, index = FALSE)

remove_redundant_old(setlist, maximal = TRUE, index = FALSE)

is_inset_old(x, setlist, index = FALSE)
}
\arguments{
\item{setlist}{List of vectors (representing a set of subsets)}

\item{index}{Logical; should indices (in setlist) be returned or a
set of subsets.}

\item{maximal}{Logical; see section 'Details' for a description.}

\item{x}{Vector representing a set.}
}
\description{
Set operations for gRbase and related packages.
}
\details{
'setlist' is a list of vectors representing a set of subsets;
 i.e. V1,...VQ where Vk is a subset of some base set V.

 'all' If true, \code{get_superset} will return index of all
 vectors containing the element; otherwise only the first index is
 returned.

 \code{is_inset}: Checks if the set
 x is in one of the Vk's.

 \code{remove_redundant}: Returns those Vk which are not contained
 in other subsets; i.e. gives the maximal sets. If maximal is FALSE
 then returns the minimal sets; i.e. Vk is returned if Vk is
 contained in one of the other sets Vl and there are no set Vn
 contained in Vk.
 
 Notice that the comparisons are made by turning the elements into
 characters and then comparing these. Hence 1 is identical to "1".
}
\examples{

set <- list(c(1, 2), c(1, 2, 3), c(2, 3, 6), c(2, 4), c(5, 6), 5)            
                                                            
el1 <- c(2, 1)                                               
el2 <- c(2, 3)                                               
el3 <- c(4, 3)                                               
el4 <- c(2, 1, 3)                                             
                                                            
maximal_sets_old(set)                                           
minimal_sets_old(set)                                           
                                                            
remove_redundant_old(set)                                       
remove_redundant_old(set, maximal=FALSE)                        
                                                            
is_inset_old(el1, set)                                          
is_inset_old(el2, set)                                          
is_inset_old(el3, set)                                          
                                                            
get_subset(el1, set)
get_subset(el1, set)                                        
get_subset(el2, set)                                        
get_subset(el3, set)                                        

get_superset(el1, set)                                      
get_superset(el1, set, all=TRUE)                                      
get_superset(el2, set)                                      
get_superset(el3, set)

is_subsetof(el1, el1)                                       
is_subsetof(el1, el2)                                       
is_subsetof(el1, el4)

}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
