% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-doc.R
\name{fit-doc}
\alias{fit-doc}
\alias{ipm.rcon}
\alias{ipm.rcor}
\alias{matching.rcon}
\alias{matching.rcor}
\alias{rconIPM_c}
\alias{rconIPM_r}
\alias{rcorIPM_c}
\alias{rcorIPM_r}
\alias{rconScoreMatch}
\alias{rcorScoreMatch}
\alias{rconScoreTheta}
\alias{rcorScoreTheta}
\alias{fitIPSedge}
\alias{fitIPSset}
\alias{fitNR2}
\alias{fitNR}
\alias{modNewt}
\alias{refitA}
\alias{refitA_old}
\title{Functions used in connection with fitting of RCOX models}
\arguments{
\item{object}{An RCOX model object (an object of class rcox.Internal)}

\item{K0}{An initial value for K}

\item{control}{A list controlling the fitting algorithms.}

\item{maxit}{Maximal number of scoring iterations}

\item{trace}{Controls various diagnostics print outs. A debugging feature
not intended for the user.}
}
\value{
A list with fitted values (K, logL etc).
}
\description{
This is an overview over core functions used in
  connection with fitting of RCOX models. The functions described
  here will typically not be directly called by the user.
}
\examples{

gm  = ~al:an:st
vcc = list(~me+st, ~ve+an, ~al)
ecc = list(~me:ve+me:al, ~ve:al+al:st)
data(math)

m1 <- rcox(gm=gm, vcc=vcc, ecc=ecc, data=math, fit=FALSE)
f1 <- matching(m1)

## Use f1$K as starting value
scoring(m1, K0=f1$K)
ipm(m1, K0=f1$K)

}
\seealso{
\code{\link{fit}}, \code{\link{rcox}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{internal}
