% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ciTest-generic.R
\name{citest-df}
\alias{citest-df}
\alias{ciTest_df}
\title{Test for conditional independence in a dataframe}
\usage{
ciTest_df(x, set = NULL, ...)
}
\arguments{
\item{x}{A dataframe.}

\item{set}{A specification of the test to be made. The tests are of
the form u and v are independent condionally on S where u and v
are variables and S is a set of variables. See 'details' for
details about specification of \code{set}.}

\item{\dots}{Additional arguments.}
}
\value{
An object of class \code{citest} (which is a list).
}
\description{
Test for conditional independence in a dataframe.
}
\details{
\code{set} can be 1) a vector or 2) a right-hand sided formula in which
variables are separated by '+'. In either case, it is tested if the first
two variables in the \code{set} are conditionally independent given the
remaining variables in \code{set}.  (Notice an abuse of the '+' operator in
the right-hand sided formula: The order of the variables does matter.)

If \code{set} is \code{NULL} then it is tested whether the first two
variables are conditionally independent given the remaining variables.

If \code{set} consists only of factors then \code{x[,set]} is converted to a
contingency table and the test is made in this table using
\code{ciTest_table()}.

If \code{set} consists only of numeric values and integers then
\code{x[,set]} is converted to a list with components \code{cov} and
\code{n.obs} by calling \code{cov.wt(x[,set], method='ML')}. This list is
then passed on to \code{ciTest_mvn()} which makes the test.
}
\examples{

data(milkcomp1)
ciTest(milkcomp1, set=~tre + fat + pro)
ciTest_df(milkcomp1, set=~tre + fat + pro)
}
\seealso{
\code{\link{ciTest}}, \code{\link{ciTest_table}},
\code{\link{ciTest_mvn}}, \code{\link{chisq.test}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{htest}
