% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-all-edges.R
\name{test-edges}
\alias{test-edges}
\alias{testEdges}
\alias{testInEdges}
\alias{testOutEdges}
\title{Test edges in graphical models with p-value/AIC value}
\usage{
testEdges(
  object,
  edgeMAT = NULL,
  ingraph = TRUE,
  criterion = "aic",
  k = 2,
  alpha = NULL,
  headlong = FALSE,
  details = 1,
  ...
)

testInEdges(
  object,
  edgeMAT = NULL,
  criterion = "aic",
  k = 2,
  alpha = NULL,
  headlong = FALSE,
  details = 1,
  ...
)

testOutEdges(
  object,
  edgeMAT = NULL,
  criterion = "aic",
  k = 2,
  alpha = NULL,
  headlong = FALSE,
  details = 1,
  ...
)
}
\arguments{
\item{object}{An \code{iModel} model object}

\item{edgeMAT}{A \code{p * 2} matrix with edges}

\item{ingraph}{If TRUE, edges in graph are tested; if FALSE, edges
not in graph are tested.}

\item{criterion}{Either \code{"aic"} or \code{"test"} (for
significance test)}

\item{k}{Penalty term when \code{criterion="aic"}. Only k=2 gives
genuine AIC.}

\item{alpha}{Critical value for deeming an edge to be significant/
insignificant. When \code{criterion="aic"}, \code{alpha}
defaults to 0; when \code{criterion="test"}, \code{alpha}
defaults to 0.05.}

\item{headlong}{If TRUE then testing will stop once a model
improvement has been found.}

\item{details}{Controls the level of printing on the screen.}

\item{\dots}{Further arguments to be passed on to \code{testdelete}
(for \code{testInEdges}) and \code{testadd} (for
\code{testOutEdges}).}
}
\value{
A dataframe with test statistics (p-value or change in
AIC), edges and logical telling if the edge can be deleted.
}
\description{
Test edges in graphical models with p-value/AIC
value. The models must be \code{iModel}s.
}
\details{
\itemize{
\item testIn: Function which tests whether each edge in "edgeList" can
be delete from model "object"
\item testOut: Is similar but in the other direction.
}
}
\examples{

data(math)
cm1 <- cmod(~me:ve + ve:al + al:an, data=math)
testEdges(cm1, ingraph=TRUE)
testEdges(cm1, ingraph=FALSE)
## Same as
# testInEdges(cm1)
# testOutEdges(cm) 
}
\seealso{
\code{\link{getEdges}}, \code{\link{testadd}},
\code{\link{testdelete}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{htest}
\keyword{models}
