% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ala_taxonomy.R
\name{ala_taxonomy}
\alias{ala_taxonomy}
\title{Search taxonomic trees}
\usage{
ala_taxonomy(taxa, down_to)
}
\arguments{
\item{taxa}{The identity of the clade for which a taxonomic
hierarchy should be returned. Should be specified using an object of class 
\code{data.frame} and \code{ala_id}, as returned from
\code{\link{select_taxa}()}.}

\item{down_to}{\code{string}: A taxonomic rank to search down to. See
\code{\link{find_ranks}()} for valid inputs.}
}
\value{
A tree consisting of objects of class \code{Node}, containing the 
requested taxonomy. Each node contains the following attributes:
\itemize{
  \item\code{name}: The scientific name of the taxon in question
  \item\code{rank}: The taxonomic rank to which that taxon belongs
  \item\code{guid}: A unique identifier used by the ALA
  \item\code{authority}: The source of the taxonomic name & identifier
}
}
\description{
The ALA has its' own internal taxonomy that is derived from authoritative
sources. \code{search_taxonomy} provides a means to query 
that taxonomy, returning a tree (class \code{Node}) showing which lower 
clades are contained within the specified taxon.
}
\details{
The approach used by this function is recursive, meaning that it  
becomes slow for large queries such as  
\code{search_taxonomy(select_taxa("Plantae"), down_to = "species")}.
Although the inputs to \code{select_taxa} and \code{down_to} are 
case-insensitive, node names are always returned in title case.
}
\examples{
\dontrun{
search_taxonomy(select_taxa("chordata"), down_to = "class")
}
}
\seealso{
\code{\link{select_taxa}} to search for an individual taxon; 
\code{\link{find_ranks}} for valid ranks used to specify the \code{down_to}
argument.
}
