% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_all_profiles.R
\name{show_all_profiles}
\alias{show_all_profiles}
\title{List data quality profiles}
\usage{
show_all_profiles()
}
\value{
An object of class \code{tbl_df} and \code{data.frame} (aka a tibble) of
available profiles
}
\description{
The ALA provides a number of pre-built data quality profiles for
filtering data according to quality checks. A data quality profile can
be specified in the \code{profile} argument in \code{\link[=galah_filter]{galah_filter()}}
and used to filter searches in \code{\link[=atlas_occurrences]{atlas_occurrences()}},
\code{\link[=atlas_counts]{atlas_counts()}} and \code{\link[=atlas_species]{atlas_species()}}.
}
\section{Examples}{


Show a list of all available data quality profiles\if{html}{\out{<div class="sourceCode r">}}\preformatted{show_all_profiles()
#> # A tibble: 7 x 4
#>      id name                                                  shortName        description                                 
#>   <int> <chr>                                                 <chr>            <chr>                                       
#> 1     2 ALA General (pre-pipelines)                           ALA-legacy       "The default ALA profile filters out record~
#> 2    35 Species Distribution Modelling (CSDM) (pre-pipelines) CSDM-legacy      "Base filters for the Collaborative Species~
#> 3    44 Data licensed for all uses (pre-pipelines)            re-usable-legacy "Data licensed for re-use, including commer~
#> 4    92 ALA General                                           ALA              "The default ALA profile filters out record~
#> 5   124 Species Distribution Modelling (CSDM)                 CSDM             "Base filters for the Collaborative Species~
#> 6   133 Data licensed for all uses                            re-usable        "Data licensed for re-use, including commer~
#> 7   224 AVH                                                   AVH              "AVH data quality profile"
}\if{html}{\out{</div>}}

Values in the \code{shortName} column can be used with \code{\link[=galah_filter]{galah_filter()}} to
narrow your data query results\if{html}{\out{<div class="sourceCode r">}}\preformatted{galah_filter(profile == "ALA")
#> Warning: Invalid field(s) detected.
#> i See a listing of all valid fields with `show_all_fields()`.
#> i Search for the valid name of a desired field with `search_fields()`.
#> x Invalid field(s): profile.
#> # A tibble: 1 x 4
#>   variable logical value query              
#>   <chr>    <chr>   <chr> <chr>              
#> 1 profile  ==      ALA   "(profile:\\"ALA\\")"
}\if{html}{\out{</div>}}
}

\seealso{
This function gives viable profile names for passing to
\code{\link[=galah_filter]{galah_filter()}}. For more detail on a given profile see
\code{\link[=search_profile_attributes]{search_profile_attributes()}}.
}
