% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galah_bbox.R
\name{galah_bbox}
\alias{galah_bbox}
\title{Narrow a query to within a bounding box}
\usage{
galah_bbox(...)
}
\arguments{
\item{...}{an \code{sf} object or a shapefile (.shp), or bounding box coordinates
supplied as a \code{bbox}, a \code{tibble}/\code{data.frame}}
}
\value{
length-1 object of class \code{character} and \code{galah_geolocate},
containing a multipolygon WKT string representing the bounding box of the
area provided.
}
\description{
Restrict results to within a bounding box (a box constructed from min/max
latitude & longitude coordinates).
Bounding boxes can be extracted from a supplied \code{sf}/\code{sfc} object or
a shapefile. A bounding box can also be supplied as a \code{bbox} object
(via \code{sf::st_bbox}) or a \code{tibble}/\code{data.frame}.
}
\details{
an \code{sf} object or a shapefile polygon will be simplified to its
bbox coordinates. A bounding box can be supplied as a \code{bbox} object or as
a \code{tibble}/\code{data.frame}. Bounding boxes supplied as a \code{tibble}/\code{data.frame}
must have "xmin", "xmax", "ymin" and "ymax" columns with valid \code{numeric}
values.
}
\examples{
\dontrun{
# Search for records using a bounding box of coordinates
b_box <- sf::st_bbox(c(xmin = 143, xmax = 148, ymin = -29, ymax = -28), 
                     crs = sf::st_crs("WGS84"))

galah_call() |>
  galah_identify("reptilia") |>
  galah_bbox(b_box) |>
  atlas_counts()

# Search for records using a bounding box in a `tibble` or `data.frame`
b_box <- tibble::tibble(xmin = 148, ymin = -29, xmax = 143, ymax = -21)

galah_call() |>
  galah_identify("reptilia") |>
  galah_bbox(b_box) |>
  atlas_counts()
  
# Search for records within the bounding box of an `sf` object
galah_config(email = "your_email_here")

location <- 
"POLYGON((143.32 -18.78,145.30 -20.52,141.52 -21.50,143.32 -18.78))" |>
 sf::st_as_sfc()
 
galah_call() |>
  galah_identify("vulpes") |>
  galah_bbox(location) |>
  atlas_occurrences()
 
# Search for records within the bounding box of a shapefile
galah_config(email = "your_email_here")

location <- sf::st_read("path/to/shapefile.shp")

galah_call() |>
  galah_identify("vulpes") |>
  galah_bbox(location) |>
  atlas_occurrences()
}

}
\seealso{
\code{\link[=galah_polygon]{galah_polygon()}} & \code{\link[=galah_geolocate]{galah_geolocate()}} for other ways to narrow
queries by location. See \code{\link[=search_taxa]{search_taxa()}}, \code{\link[=galah_filter]{galah_filter()}} and
\code{\link[=galah_select]{galah_select()}} for other ways to restrict the information
returned by \code{\link[=atlas_occurrences]{atlas_occurrences()}} and related functions.
}
\keyword{internal}
