% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galah_group_by.R
\name{galah_group_by}
\alias{galah_group_by}
\title{Specify fields to group when downloading record counts}
\usage{
galah_group_by(..., expand = TRUE)
}
\arguments{
\item{...}{zero or more individual column names to include}

\item{expand}{\code{logical}: When passed to \code{group_by} argument of
\code{atlas_counts}, should factor levels be expanded? Defaults to \code{TRUE}.}
}
\value{
If any arguments are provided, returns a \code{data.frame} with
columns \code{name} and \code{type}, as per \code{\link[=galah_select]{galah_select()}}; if no arguments
are provided, returns \code{NULL}.
}
\description{
\code{atlas_counts} supports server-side grouping of data. Grouping can be
used to return record counts grouped by multiple, valid fields (found by
\code{search_all(fields)}. Use \code{galah_group_by} when using the
\code{group_by} argument of \code{atlas_counts} to return record counts summed
by one or more valid fields.
}
\examples{
\dontrun{
galah_call() |> 
  galah_group_by(basisOfRecord) |>
  atlas_counts()
}

}
\seealso{
\code{\link[=galah_select]{galah_select()}}, \code{\link[=galah_filter]{galah_filter()}} and
\code{\link[=galah_geolocate]{galah_geolocate()}} for related methods.
}
