% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse.R
\name{collapse_galah}
\alias{collapse_galah}
\alias{collapse.data_request}
\alias{collapse.metadata_request}
\alias{collapse.files_request}
\title{Generate a query}
\usage{
\method{collapse}{data_request}(x, ..., mint_doi)

\method{collapse}{metadata_request}(x, ...)

\method{collapse}{files_request}(x, ..., thumbnail = FALSE)
}
\arguments{
\item{x}{An object of class \code{data_request}, \code{metadata_request} or
\code{files_request}}

\item{...}{Arguments passed on to methods}

\item{mint_doi}{Logical: should a DOI be minted for this download? Only
applies to \code{type = "occurrences"} when atlas chosen is "ALA".}

\item{thumbnail}{Logical: should thumbnail-size images be returned? Defaults
to \code{FALSE}, indicating full-size images are required.}
}
\value{
An object of class \code{query_set}, which is a list containing one or
more objects of class \code{query}. This is valuable because it shows the set of
queries required to correctly retrieve the requested data. Objects within a
\code{query_set} are listed in the sequence in which they will be enacted.
}
\description{
\code{collapse()} constructs a valid query so it can be
inspected before being sent. It typically occurs at the end of a pipe,
traditionally begun with \code{galah_call()}, that is used to define a query.
As of version 2.0, objects of class \code{data_request} (created using
\code{request_data()}), \code{metadata_request} (from \code{request_metadata()}) or
\code{files_request} (from \code{request_files()}) are all supported by \code{collapse()}.
Any of these objects can be created using \code{galah_call()} via the \code{method}
argument.
}
