% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice_head.R
\name{slice_head.data_request}
\alias{slice_head.data_request}
\alias{slice_head.metadata_request}
\title{Subset first rows of \code{data_request}}
\usage{
\method{slice_head}{data_request}(.data, ..., n, prop, by = NULL)

\method{slice_head}{metadata_request}(.data, ..., n, prop, by = NULL)
}
\arguments{
\item{.data}{An object of class \code{data_request}, created using \code{\link[=galah_call]{galah_call()}}}

\item{...}{currently ignored}

\item{n}{The number of rows to be returned. If data are grouped
(using \link{group_by}), this operation will be performed on each group.}

\item{prop}{currently ignored, but could be added later}

\item{by}{currently ignored}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This is a simple function to set the \code{limit} argument in \code{\link[=atlas_counts]{atlas_counts()}}
using \code{dplyr} syntax. As of galah 2.0.0, \code{slice_head()} is only supported in
queries of type \code{occurrences-count()}, or metadata requests. Note also that
\code{slice_head()} is lazily evaluated; it only affects a query once it is run by
\code{compute()} or (more likely) \code{collect()}.
}
\examples{
\dontrun{
# Limit number of rows returned to 3.
# In this case, our query returns the top 3 years with most records.
galah_call() |>
  identify("perameles") |>
  filter(year > 2010) |>
  group_by(year) |>
  count() |>
  slice_head(n = 3) |>
  collect()
}
}
