% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_metadata.R
\name{use_metadata}
\alias{use_metadata}
\title{Use a metadata statement in a Darwin Core Archive}
\usage{
use_metadata(file = NULL, overwrite = FALSE, quiet = FALSE)
}
\arguments{
\item{file}{A metadata file in Rmarkdown (\code{.Rmd}) or Quarto markdown (\code{.qmd})
format.}

\item{overwrite}{By default, \code{use_metadata()} will not
overwrite existing files. If you really want to do so, set this to \code{TRUE}.}

\item{quiet}{Whether to message about what is happening. Default is set to
\code{FALSE}.}
}
\value{
Does not return an object to the workspace; called for the side
effect of building a file in the \code{data-publish} directory.
}
\description{
A metadata statement lists the owner of the dataset, how it was collected,
and how it can be used (i.e. its' licence). This function reads and
converts metadata saved in markdown (.md), Rmarkdown (.Rmd) or Quarto (.qmd)
to xml, and saves it in the \code{data-publish} directory.

This function is a convenience wrapper function of \code{\link[delma:read_md]{delma::read_md()}} and
\code{\link[delma:write_eml]{delma::write_eml()}}.
}
\details{
To be compliant with the Darwin Core Standard, the schema file \strong{must} be
called \code{eml.xml}, and this function enforces that.
}
\examples{
\dontshow{
.old_wd <- getwd()
temp_dir <- tempdir()
usethis::proj_set(path = temp_dir, force = TRUE)
setwd(temp_dir)
}

# Get a boilerplate metadata statement
use_metadata_template(file = "my_metadata.Rmd", quiet = TRUE)

# Once editing is complete, call `use_metadata()` to convert to an EML file
use_metadata("my_metadata.Rmd", quiet = TRUE)

# Check that file has been created
list.files("data-publish")

# returns "eml.xml" as expected

\dontshow{
unlink("my_metadata.Rmd")
unlink("data-publish", recursive = TRUE)
usethis::proj_set(path = .old_wd, force = TRUE)
setwd(.old_wd)
}
}
\seealso{
\code{\link[=use_metadata_template]{use_metadata_template()}} to create a metadata statement template;
\code{\link[=use_data]{use_data()}} to save data to \verb{/data-publish}.
}
