% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permu.gamhp.r
\name{permu.gamhp}
\alias{permu.gamhp}
\title{Permutation Test of Hierarchical Partitioning for GAM Analysis}
\usage{
permu.gamhp(mod = NULL, iv = NULL, type = "dev", permutations = 10)
}
\arguments{
\item{mod}{gam model generated by mgcv::gam()}

\item{iv}{optional The relative importance of predictor groups will be assessed. The input for iv should be a list, where each element contains the names of variables belonging to a specific group. These variable names must correspond to the predictor variables defined in the model (mod).}

\item{type}{The type of total explained variation, either "dev" or "adjR2", in which "dev" is deviance explained and "adjR2" is adjusted R-square, the default is "adjR2".}

\item{permutations}{An integer; Number of permutations for computing p value of individual contribution for the randomized dataset.}
}
\value{
a data.frame containing a summary table listing the observed individual contribution, the p value of individual contribution for the randomized dataset
}
\description{
Permutation Test of Hierarchical Partitioning for GAM Analysis
}
\details{
This function is a permutation test of hierarchical partitioning for gam analysis. It returns a matrix of I values (the individual contribution towards total explained variation) for all values from permutations randomizations. For each permutation, the values in each variable (i.e each column of iv) are randomized independently, and gam.hp is run on the randomized iv. As well as the randomized I matrix, the function returns a summary table listing the observed I values, the p value of I for the randomized dataset.
}
\examples{
library(mgcv)
mod1 <- gam(Sepal.Length ~ s(Petal.Length) + s(Petal.Width) + Sepal.Width,data = iris)
permu.gamhp(mod=mod1,type="dev",permutations=10)
iv <- list(env1=c("s(Petal.Length)","s(Petal.Width)"),env2="Sepal.Width")
permu.gamhp(mod=mod1,iv,type="dev",permutations=10)
}
\author{
{Jiangshan Lai} \email{lai@njfu.edu.cn}
}
