% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/summarize.R
\docType{methods}
\name{summarise}
\alias{summarise}
\alias{summarise-method}
\alias{summarise,GammaSpectrum-method}
\alias{summarise,GammaSpectra-method}
\alias{summarise,DoseRateModel-method}
\alias{summarise,CalibrationCurve-method}
\title{Summarize}
\usage{
summarise(object, ...)

\S4method{summarise}{GammaSpectrum}(object)

\S4method{summarise}{GammaSpectra}(object)

\S4method{summarise}{DoseRateModel}(object)

\S4method{summarise}{CalibrationCurve}(object)
}
\arguments{
\item{object}{A \linkS4class{GammaSpectrum} or \linkS4class{GammaSpectra}
object.}

\item{...}{Currently not used.}
}
\value{
A \code{\link{data.frame}}.
}
\description{
Summarize
}
\examples{
## Import a Canberra CNF file
cnf_file <- system.file("extdata/LaBr.CNF", package = "gamma")
spc <- read(cnf_file)
summarise(spc)

## Import all CNF files in a given directory
spc_dir <- system.file("extdata/BDX_LaBr_1/calibration", package = "gamma")
spc <- read(spc_dir)
summarise(spc)
}
\seealso{
Other IO: 
\code{\link{read}()}
}
\author{
N. Frerebeau
}
\concept{IO}
