## This file is compiled on 9-1-2004 (GMT)
##
## fisher.test
#
# This will be suitable for analysis of population-based case-control data with single multiallelic marker
# library(ctest)
# ? fisher.test

## GENECOUNTING
#
# This is the orginal example used in EHPLUS (Zhao et al. 2000 Hum Hered), based on Dr T Li's COMT data
#
cat(
"1003.0 1   1 2   1 2",
"1003.1 0   1 2   1 2",
"1003.2 0   1 2   1 1",
"1005.0 1   1 1   1 2",
"1005.1 0   1 1   1 2",
"1005.2 0   1 2   1 1",
"1006.0 1   2 2   2 2",
"1006.1 0   1 2   2 2",
"1006.2 0   2 2   1 2",
"1007.0 1   1 1   1 2",
"1007.1 0   1 1   1 2",
"1007.2 0   1 2   1 1", file="gcex.dat",sep="\n")

library(gap)
ex<-read.table("gcex.dat")
ex
count<-rep(1,12)
ex.gc<-genecounting(ex[,3:6],count)
summary(ex.gc)

## HAPLOTYPE TREND REGRESSION
#
# This is an example extracted from HTR program by Dimitri Zaykin
#
cat(" 2.53360986   0.00000000   0.00000000   0.00008314   0.49995843   0.00000000   0.00000000   0.00000000   0.00000000   0.49995843",
" 0.88793544   0.00000000   0.00000000   0.50000000   0.50000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000",
"-0.54866374   0.00000000   0.00000000   0.00000000   0.00000000   0.27267174   0.22732826   0.22732826   0.27267174   0.00000000",
" 1.58534650   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00007547   0.49996226   0.49996226",
"-6.72637802   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.50000000   0.50000000   0.00000000",
" 6.54283632   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   1.00000000   0.00000000",
"-0.05516702   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   1.00000000   0.00000000",
"-0.67776336   0.00000000   0.00000000   0.50000000   0.50000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000",
" 1.84912367   0.00000000   0.00000000   0.00000000   0.00000000   0.27267174   0.22732826   0.22732826   0.27267174   0.00000000",
" 1.46657404   0.00000000   0.00000000   0.26208396   0.23791604   0.00000000   0.00000000   0.23791604   0.26208396   0.00000000",
" 3.80331334   0.40792847   0.00000000   0.09207153   0.00000000   0.09207153   0.00000000   0.40792847   0.00000000   0.00000000",
"-7.58579055   0.00000000   0.00000000   0.26208396   0.23791604   0.00000000   0.00000000   0.23791604   0.26208396   0.00000000",
" 5.68539639   0.00000000   0.00000000   0.00000000   1.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000",
" 6.29834856   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   1.00000000   0.00000000",
"-1.63459654   0.39808764   0.10191236   0.10191236   0.39808764   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000",
"-8.67413674   0.00000000   0.00000000   0.26208396   0.23791604   0.00000000   0.00000000   0.23791604   0.26208396   0.00000000",
"-4.84468181   0.40792847   0.00000000   0.09207153   0.00000000   0.09207153   0.00000000   0.40792847   0.00000000   0.00000000",
"-3.58270721   0.00000000   0.00000000   0.50000000   0.00000000   0.00000000   0.00000000   0.50000000   0.00000000   0.00000000",
"-3.23258727   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.50000000   0.50000000   0.00000000",
"-5.98408350   0.00000000   0.00000000   0.50000000   0.50000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000",
"-0.08095271   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   1.00000000   0.00000000   0.00000000",
" 0.97333894   0.39100620   0.10899380   0.00000000   0.00000000   0.10899380   0.39100620   0.00000000   0.00000000   0.00000000",
"-0.25215647   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   1.00000000   0.00000000",
" 5.29363356   0.00000000   0.00000000   0.00000000   0.50000000   0.00000000   0.00000000   0.00000000   0.50000000   0.00000000",
" 4.92042950   0.00000000   0.00000000   0.00000000   0.00000000   0.27267174   0.22732826   0.22732826   0.27267174   0.00000000",
"-0.60395261   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   1.00000000   0.00000000",
"-1.30303946   0.00000000   0.00000000   0.00000000   0.50000000   0.00000000   0.00000000   0.00000000   0.50000000   0.00000000",
"-10.78518036   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.50000000   0.50000000   0.00000000",
" 2.44024012   0.00000000   0.00000000   0.00000000   1.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000",
" 1.68644718   0.30760501   0.07148664   0.05788260   0.06302575   0.06302575   0.05788260   0.07148664   0.30760501   0.00000000",
" 0.56227982   0.39100620   0.10899380   0.00000000   0.00000000   0.10899380   0.39100620   0.00000000   0.00000000   0.00000000",
" 4.32765484   0.00000000   0.00000000   0.50000000   0.50000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000",
"-7.00755625   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.50000000   0.50000000   0.00000000",
" 1.92632651   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.50000000   0.50000000   0.00000000",
"-5.15965407   0.00000000   0.00000000   0.00000000   0.50000000   0.00000000   0.00000000   0.00000000   0.50000000   0.00000000",
" 1.41948465   0.30760501   0.07148664   0.05788260   0.06302575   0.06302575   0.05788260   0.07148664   0.30760501   0.00000000",
"-1.24407701   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   1.00000000   0.00000000",
" 1.30487705   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.50000000   0.50000000   0.00000000",
" 3.09953383   0.00000000   0.00000000   0.26208396   0.23791604   0.00000000   0.00000000   0.23791604   0.26208396   0.00000000",
"-3.25996408   0.00000000   0.00000000   0.26208396   0.23791604   0.00000000   0.00000000   0.23791604   0.26208396   0.00000000",
"-9.29937118   0.00000000   0.00000000   0.50000000   0.50000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000",
"-2.59661108   0.30760501   0.07148664   0.05788260   0.06302575   0.06302575   0.05788260   0.07148664   0.30760501   0.00000000",
"-8.99422756   0.00000000   0.00000000   0.00000000   0.00000000   0.50000000   0.50000000   0.00000000   0.00000000   0.00000000",
"-3.11178018   0.50000000   0.50000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000",
"-2.62968995   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.50000000   0.50000000   0.00000000",
" 4.38591735   0.00000000   0.00000000   0.00000000   0.00000000   0.27267174   0.22732826   0.22732826   0.27267174   0.00000000",
" 0.89487508   0.30760501   0.07148664   0.05788260   0.06302575   0.06302575   0.05788260   0.07148664   0.30760501   0.00000000",
" 0.21564785   0.39808764   0.10191236   0.10191236   0.39808764   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000",
" 2.19074659   0.00000000   0.00000000   0.00000000   0.50000000   0.00000000   0.00000000   0.00000000   0.50000000   0.00000000",
"11.10364441   0.40792847   0.00000000   0.09207153   0.00000000   0.09207153   0.00000000   0.40792847   0.00000000   0.00000000",
"-5.76268685   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.50000000   0.50000000   0.00000000",
"10.83476931   0.00000000   0.50000000   0.00000000   0.50000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000",
"-3.57983971   0.00000000   0.28817907   0.00000000   0.21182093   0.00000000   0.21182093   0.00000000   0.28817907   0.00000000",
" 2.27804802   0.00000000   0.00000000   0.00000000   0.50000000   0.00000000   0.00000000   0.00000000   0.50000000   0.00000000",
"-0.90853126   0.40792847   0.00000000   0.09207153   0.00000000   0.09207153   0.00000000   0.40792847   0.00000000   0.00000000",
" 8.83342419   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.50000000   0.50000000   0.00000000",
"-2.61052385   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.50000000   0.50000000   0.00000000",
"-1.64024669   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.50000000   0.50000000   0.00000000",
"-1.46690240   0.00000000   0.50000000   0.00000000   0.00000000   0.00000000   0.50000000   0.00000000   0.00000000   0.00000000",
"-2.40575606   0.00000000   0.00000000   0.26208396   0.23791604   0.00000000   0.00000000   0.23791604   0.26208396   0.00000000",
"-14.73780539   0.00000000   0.00000000   0.00000000   0.50000000   0.00000000   0.00000000   0.00000000   0.50000000   0.00000000",
" 1.86956410   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.50000000   0.00000000   0.50000000   0.00000000",
" 0.77231259   0.00000000   0.28817907   0.00000000   0.21182093   0.00000000   0.21182093   0.00000000   0.28817907   0.00000000",
" 3.19967959   0.00000000   0.00000000   1.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000",
" 3.80952199   0.39100620   0.10899380   0.00000000   0.00000000   0.10899380   0.39100620   0.00000000   0.00000000   0.00000000",
"-6.27814179   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   1.00000000   0.00000000",
" 4.77589234   0.00000000   0.00000000   0.00000000   0.50000000   0.00000000   0.00000000   0.00000000   0.50000000   0.00000000",
"-9.50058756   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   1.00000000   0.00000000",
" 1.76442440   0.00000000   0.00000000   0.00000000   0.50000000   0.00000000   0.00000000   0.00000000   0.50000000   0.00000000",
" 8.38963859   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.50000000   0.00000000   0.50000000   0.00000000",
" 9.94751176   1.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000",
"-7.65701741   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   1.00000000   0.00000000",
"-3.03348666   0.00000000   0.00000000   0.50000000   0.50000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000",
"-7.14686103   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   1.00000000   0.00000000",
" 3.62406391   0.40792847   0.00000000   0.09207153   0.00000000   0.09207153   0.00000000   0.40792847   0.00000000   0.00000000",
" 0.76228914   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.50000000   0.50000000   0.00000000",
" 7.32627269   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   1.00000000   0.00000000   0.00000000",
"-2.48937314   0.00000000   0.50000000   0.00000000   0.50000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000",
"-3.58938499   0.30760501   0.07148664   0.05788260   0.06302575   0.06302575   0.05788260   0.07148664   0.30760501   0.00000000",
" 1.18168922   0.30760501   0.07148664   0.05788260   0.06302575   0.06302575   0.05788260   0.07148664   0.30760501   0.00000000",
"-6.31683710   0.00000000   0.28817907   0.00000000   0.21182093   0.00000000   0.21182093   0.00000000   0.28817907   0.00000000",
" 5.85174589   0.39808764   0.10191236   0.10191236   0.39808764   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000",
" 1.79699848   0.00000000   0.00000000   0.26208396   0.23791604   0.00000000   0.00000000   0.23791604   0.26208396   0.00000000",
"-4.06612246   0.00000000   0.00000000   0.00000000   0.50000000   0.00000000   0.00000000   0.00000000   0.50000000   0.00000000",
" 2.48316498   0.00000000   0.28817907   0.00000000   0.21182093   0.00000000   0.21182093   0.00000000   0.28817907   0.00000000",
" 1.96723412   1.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000",
"-3.16257163   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   1.00000000   0.00000000   0.00000000",
" 5.62490077   0.00000000   0.00000000   0.26208396   0.23791604   0.00000000   0.00000000   0.23791604   0.26208396   0.00000000",
" 3.60957948   0.00000000   0.00000000   0.00000000   0.00000000   0.50000000   0.50000000   0.00000000   0.00000000   0.00000000",
" 5.00978854   0.00000000   0.00000000   0.50000000   0.50000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000",
" 2.52052152   0.00000000   0.00000000   0.26208396   0.23791604   0.00000000   0.00000000   0.23791604   0.26208396   0.00000000",
"-9.26938306   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   1.00000000   0.00000000",
"-1.03750259   0.40792847   0.00000000   0.09207153   0.00000000   0.09207153   0.00000000   0.40792847   0.00000000   0.00000000",
" 2.22332564   0.00000000   0.00000000   0.00000000   0.00000000   0.27267174   0.22732826   0.22732826   0.27267174   0.00000000",
"-0.28191752   0.00000000   0.00000000   0.50000000   0.50000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000",
" 9.28069102   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.50000000   0.50000000   0.00000000",
" 3.12788935   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   1.00000000   0.00000000",
"-2.46973022   0.00000000   0.00000000   0.26208396   0.23791604   0.00000000   0.00000000   0.23791604   0.26208396   0.00000000",
" 3.59210853   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   0.00000000   1.00000000   0.00000000",
file="test2.dat",sep="\n")

test2<-read.table("test2.dat")
y<-test2[,1]
x<-test2[,-1]
y<-as.matrix(y)
x<-as.matrix(x)
htr.test2<-htr(y,x)
htr.test2
htr.test2<-htr(y,x,n.sim=10)
htr.test2

# q('no')
