\name{klem}
\alias{klem}
\title{Haplotype frequency estimation based on a genotype table of two multiallelic markers}
\usage{klem(obs, k=2, l=2)}

\description{
Haplotype frequency estimation using expectation-maximization algorithm based on a table of genotypes of two
multiallelic markers.
}
\arguments{
 \item{obs}{a table of genotype counts}
 \item{k}{number of alleles at marker 1}
 \item{l}{number of alleles at marker 2}
}

\details{
The dimension of the genotype table should be k*(k+1)/2 x l*(l+1)/2.

Modified from 2ld.c.
}

\value{
The returned value is a list containing:
 \item{h}{haplotype Frequencies}
 \item{l0}{log-likelihood under linkage equilibrium}
 \item{l1}{log-likelihood under linkage disequilibrium}
}

\seealso{
\code{\link[gap]{genecounting}} 
}

\examples{
\dontrun{
# an example with known genotype counts 
z <- klem(obs=1:9)
# an example with imputed genotypes at SH2B1
cwd <- getwd()
cs.dir <- file.path(.path.package("gap"),"doc","klem")
setwd(cs.dir)
dir()
source("SH2B1.R",echo=TRUE)
setwd(cwd)
}
}
\author{Jing Hua Zhao}
\keyword{htest}
