% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disparityplot.R
\name{disparityplot}
\alias{disparityplot}
\title{Plot a disparity}
\usage{
disparityplot(
  x,
  category_A,
  category_B,
  custom_ylab = "Mean Outcome",
  custom_xlab = "Category"
)
}
\arguments{
\item{x}{An object of class \code{gapclosing}, which results from a call to the function \code{gapclosing}}

\item{category_A}{The first category to be plotted. A value of the category_name variable in x.}

\item{category_B}{The second category to be plotted. Must be a value of \code{x$category}}

\item{custom_ylab}{Custom y-axis label. Defaults to "Mean Outcome"}

\item{custom_xlab}{Custom x-axis label. Defaults to "Category"}
}
\value{
A \code{ggplot2} object
}
\description{
Plots the factual and counterfactual mean outcomes in two categories. The returned object is a ggplot2 object which can be further customized using the syntax of ggplot2.
}
\references{
Lundberg I (2021). "The gap-closing estimand: A causal approach to study interventions that close disparities across social categories." Sociological Methods and Research. Available at {https://osf.io/gx4y3/}.
}
