% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gap_data.R
\name{gap_data}
\alias{gap_data}
\title{Generate a gapdata class object from a dendrogram object}
\usage{
gap_data(
  d,
  mode = c("quantitative", "threshold"),
  mapping = c("exponential", "linear"),
  ratio = 0.2,
  scale = 0.5,
  threshold = 0,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{d}{dendrogram class object}

\item{mode}{gap mode, either "threshold" or "quantitative"}

\item{mapping}{in case of quantitative mode, either "linear" or "exponential" mapping}

\item{ratio}{the percentage of width allocated for the sum of gaps.}

\item{scale}{the sclae log base for the exponential mapping}

\item{threshold}{the height at which the dendrogram is cult to infer clusters}

\item{verbose}{logical for whether in verbose mode or not}

\item{...}{ignored}
}
\value{
a list of data frames that contain coordinates for drawing a gapped dendrogram
}
\description{
This function takes a dendrogram class object as an input, and generate a gapdata class object as an output.
By parsing the dendrogram object based on parameters for gaps, gaps between leaves in a dendrogram are introduced,
and the coordinates of the leaves are adjusted. The gaps can be based on the a height (or distance) threshold to
to introduce the gaps of the same width, or quantitative mapping of distance values mapped linearly or exponentially.
}
