% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SURE_MSEthresh.R
\name{SURE_MSEthresh}
\alias{SURE_MSEthresh}
\title{Stein's Unbiased Risk Estimate with MSE}
\usage{
SURE_MSEthresh(
  wcn,
  wcf,
  thresh,
  diagWWt,
  beta = 2,
  sigma,
  hatsigma = NA,
  policy = "uniform",
  keepwc = TRUE
)
}
\arguments{
\item{wcn}{Numeric vector of the noisy spectral graph wavelet coefficients.}

\item{wcf}{Numeric vector of the true spectral graph wavelet coefficients.}

\item{thresh}{Numeric vector of threshold values.}

\item{diagWWt}{Numeric vector of weights typically derived from the diagonal elements of the wavelet frame matrix.}

\item{beta}{A numeric value specifying the type of thresholding to be used:
\itemize{
           \item 1 for soft thresholding.
           \item 2 for James-Stein thresholding.
           }}

\item{sigma}{A numeric value representing the standard deviation (sd) of the noise.}

\item{hatsigma}{An optional numeric value providing an estimate of the noise standard deviation (default is NA).}

\item{policy}{A character string determining the thresholding policy. Valid options include:
\itemize{
    \item "uniform" for a global threshold applied uniformly across all coefficients.
    \item "dependent" for threshold values that adaptively depend on the corresponding `diagWWt` weights.
              }}

\item{keepwc}{A logical value determining if the thresholded wavelet coefficients should be returned (Default is TRUE).}
}
\value{
A list containing:
\itemize{
        \item A dataframe with calculated MSE, SURE, and hatSURE values.
        \item Minima of SURE, hatSURE, and MSE, and their corresponding optimal thresholds.
        \item Thresholded wavelet coefficients (if \code{keepwc = TRUE}).
        }
}
\description{
Adaptive Threshold Selection Using Principle of SURE with the inclusion of Mean Squared Error (MSE) for comparison.
}
\details{
\code{SURE_MSEthresh} function extends the \code{SUREthresh} function by providing an MSE between the true coefficients and their thresholded versions for a given thresholding function \eqn{h}. This allows for a more comprehensive evaluation of the denoising quality in simulated scenarios where the true function is known.
}
\references{
Donoho, D. L., & Johnstone, I. M. (1995). Adapting to unknown smoothness via wavelet shrinkage. Journal of the american statistical association, 90(432), 1200-1224.

de Loynes, B., Navarro, F., Olivier, B. (2021). Data-driven thresholding in denoising with Spectral Graph Wavelet Transform. Journal of Computational and Applied Mathematics, Vol. 389.

Stein, C. M. (1981). Estimation of the mean of a multivariate normal distribution. The annals of Statistics, 1135-1151.
}
\seealso{
\code{\link{SUREthresh}}, \code{\link{GVN}}, \code{\link{HPFVN}}
}
