% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_fix_names.R
\name{filter_fix_names}
\alias{filter_fix_names}
\title{Used in gators_download() -  Filter iDigBio results by scientific name}
\usage{
filter_fix_names(
  df,
  synonyms.list,
  filter = "fuzzy",
  scientific.name = "scientificName",
  accepted.name = NA
)
}
\arguments{
\item{df}{Data frame with name column to be fixed.}

\item{synonyms.list}{A list of synonyms for a species.}

\item{filter}{Default = "fuzzy". Indicates the type of filter to be used--either "exact" or "fuzzy".}

\item{scientific.name}{Default = "scientificName". The name of the scientific name column in the data frame.}

\item{accepted.name}{The accepted scientific name for the species. If provided, an additional column will be added to the data frame with the accepted name for further manual comparison.}
}
\value{
Returns data frame with filtered results.
}
\description{
The \code{filter_fix_names()} function filters a data frame for relevant results, based on the scientific name given.
Some downloaded results from iDigBio might contain occurrences of other species that have "notes" mentioning
the desired species. Hence, this function looks for relevant results that are actually occurrences of the
desired species.
}
\details{
This function requires no additional packages.
}
\examples{
cleaned_data <- filter_fix_names(data, c("Galax urceolata", "Galax aphylla"), filter = "exact")
cleaned_data <- filter_fix_names(data, c("Galax urceolata", "Galax aphylla"),
accepted.name = "Galax urceolata")

}
