% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frobregp.R
\name{frrgp}
\alias{frrgp}
\title{Robust regression using Huber's psi-function or Hampel's three part redescending psi-function providing P-values}
\usage{
frrgp(y,x,cn=1,cnr=c(2,4,8),sg=0,q=-1,ind=0,scale=T,inr=T,xinr=F,red=F)
}
\arguments{
\item{y}{Dependent variable}

\item{x}{Covariates}

\item{cn}{Tuning constant for Huber's psi-function}

\item{cnr}{Thuning constants for Hampel's three part redescending psi function}

\item{sg}{Scale}

\item{q}{The number of covariates available}

\item{ind}{The subset of covariates for which the results are required}

\item{scale}{Logical. If TRUE sclae sg recaculted}

\item{inr}{Logical, TRUE  to include intercept}

\item{xinr}{Logical TRUE if x already includes intercept}

\item{red}{ Logical It true Hampel's three part redescending psi function}
}
\value{
ppi In order the subset ind, the regression coefficients, the P-values, the standard P-values

res  Residuals

sig  Scale

rho Sums of rho, psi and psi1 functions.
}
\description{
Robust regression using Huber's psi-function  or Hampel's three part redescending psi-function providing P-values
}
\examples{
data(boston)
a<-frrgp(boston[,14],boston[,1:13])
}
