% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_gaussian_2D.R
\name{predict_gaussian_2D}
\alias{predict_gaussian_2D}
\title{Predict values from a fitted 2D gaussian}
\usage{
predict_gaussian_2D(fit_params, X_values, Y_values, ...)
}
\arguments{
\item{fit_params}{vector of parameters for a 2D Gaussian that have been
fitted to a data set. See \code{gaussplotR::fit_gaussian_2D()} for details.
The resultant object from that function can be used here.}

\item{X_values}{vector of numeric values for the x-axis}

\item{Y_values}{vector of numeric values for the y-axis}

\item{...}{Additional arguments}
}
\value{
A data.frame with the supplied \code{X_values} and \code{Y_values}
along with the predicted values of the 2D gaussian
(\code{predicted_values})
}
\description{
Predict values from a fitted 2D gaussian
}
\section{Warning}{

This function assumes Gaussian parameters have been fitted beforehand. No
fitting of parameters is done within this function; they all must be
supplied via the object created by \code{gaussplotR::fit_gaussian_2D()}.
}

\examples{
if (interactive()) {
  ## Load the sample data set
  data(gaussplot_sample_data)

  ## The raw data we'd like to use are in columns 1:3
  samp_dat <-
    gaussplot_sample_data[,1:3]


  #### Example 1: Unconstrained elliptical ####
  gauss_fit <-
    fit_gaussian_2D(samp_dat)
  ## This fits an unconstrained elliptical by default
  attr(gauss_fit, "fit_method")

  ## Generate a grid of x- and y- values on which to predict
  grid <-
    expand.grid(X_values = seq(from = -5, to = 0, by = 0.1),
                Y_values = seq(from = -1, to = 4, by = 0.1))

  ## Predict the values using predict_gaussian_2D
  gauss_data <-
    predict_gaussian_2D(
      fit_params = gauss_fit,
      X_values = grid$X_values,
      Y_values = grid$Y_values,
    )

  ## Plot via ggplot2 and metR
  library(ggplot2); library(metR)
  ggplot_gaussian_2D(gauss_data)

  #### Example 2: Constrained elliptical_log ####
  gauss_fit <-
    fit_gaussian_2D(
      samp_dat,
      method = "elliptical_log",
      orientation_strategy = -1
    )
  ## This fits a constrained elliptical, as in Priebe et al. 2003
  attr(gauss_fit, "fit_method")

  ## Generate a grid of x- and y- values on which to predict
  grid <-
    expand.grid(X_values = seq(from = -5, to = 0, by = 0.1),
                Y_values = seq(from = -1, to = 4, by = 0.1))

  ## Predict the values using predict_gaussian_2D
  gauss_data <-
    predict_gaussian_2D(
      fit_params = gauss_fit,
      X_values = grid$X_values,
      Y_values = grid$Y_values,
    )

  ## Plot via ggplot2 and metR
  ggplot_gaussian_2D(gauss_data)
}
}
\author{
Vikram B. Baliga
}
