% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GAgawdis.R
\name{GAgawdis}
\alias{GAgawdis}
\title{Internal Genetic Algorithm gawdis function}
\usage{
GAgawdis( tr = NULL, asym.bin = NULL, ord = "podani",gr = NULL,
gr.weight = FALSE, fuzzy = NULL, getSpecDists = NULL,
f = NULL, min.weight = 0.001, max.weight = 1, maxiter = 300,
monitor = FALSE, ... )
}
\arguments{
\item{tr}{Matrix or data frame containing the variables. Variables can be numeric, ordered, or factor. Symmetric or asymmetric binary variables should be numeric and only contain 0 and 1. Character variables will be converted to factor. NAs are tolerated.}

\item{asym.bin}{Vector listing the asymmetric binary variables in x.}

\item{ord}{Character string specifying the method to be used for ordinal variables (i.e. ordered). \code{podani} refers to Eqs. 2a-b of Podani (1999), while "metric" refers to his Eq. 3 (see ‘Details’); both options convert ordinal variables to ranks. "classic" simply treats ordinal variables as continuous variables.}

\item{gr}{Vector for traits grouping, i.e. defining group of traits that are considered to be reflecting similar biological information (e.g. many leaf traits in plants covering similar information). By default each trait is treated separately (\code{groups=NULL}). In order to define groups use the same values, e.g. \code{groups = c(1,2,2,2,3,3)} in case of 6 variables attributed to 3 groups, with the length of vector that should be the same as \code{ncol(x)}.}

\item{gr.weight}{Option to weight traits inside the groups. By default it is set to FALSE, all traits inside the groups have the same weights, meaning that some traits will have a greater contribution within the group; TRUE means that \code{gawdis()} will determine different weights of traits inside the groups, before combining this group with other traits outside the group.}

\item{fuzzy}{Vector including groups which are defining a single variable, like in the case of fuzzy coding and dummy variables. In this case, use the argument \code{groups} to define which columns belong to the groups. If \code{fuzzy} includes group name (from \code{groups} argument), then the function will transform distances between species within specified group to have maximum value set to 1 (e.g. for \code{groups=c(1,1,2,2,2),fuzzy=c(2)} only distances of group 2 will be transformed). Default is NULL, not to transform distances of any group. Having both \code{groups.weight=TRUE, fuzzy=TRUE} is not possible, therefore \code{!is.null(fuzzy)} leads to overwriting \code{groups.weight} to FALSE.}

\item{getSpecDists}{Allows to use own code that defines the function \code{getSpecDists(tr,gr,gr.weight)} for computing distances between species for each trait (traits are passed as tr argument). It can be given, or pre-defined function doing the same things as \code{gowdis()} is used (it is not necessary to specify it). If groups and groups.weight arguments are given in gawdis, then they are passed to \code{getSpecDists()} as gr and gr.weight arguments.}

\item{f}{This is the criteria used to equalize the contribution of traits to the multi-trait dissimilarity. It can be specified. Alternative, by default, the approach is minimizing the differences in the correlations between the dissimilarity on individual trait and the multi-trait approach. Specifically the  1/SD of correlations (SD=standard deviation) is used, i.e. all traits will tend to have a similar correlation with the multi-trait dissimilarity. opti.f is fitness function that is maximalized by genetic algorithm.}

\item{min.weight}{Set minimum value for weights of traits.}

\item{max.weight}{Set maximum value for weights of traits.}

\item{maxiter}{Maximum number of iterations to run before the GA search is halted, see \code{?ga} from GA package. The default is 300 which was found to be quite reliable. The greater numbers increase the computation time.}

\item{monitor}{If to monit progress of genetic algorithm.}

\item{...}{Arguments passed to GA}
}
\value{
Returns 'diss' as dissimilarity, weights as solution of GA, ga as GA, spedis as species distance.
}
\description{
Internal part of \code{gawdis()} function for running genetic algorithm
}
\examples{
#GAgawdis() is not exptected to be run directly, but you can try it by
\donttest{
 library(FD)
 GAgawdis(dummy$trait,maxiter=100)
 }

}
\keyword{gawdis}
\keyword{gowdis}
