% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcefg.R
\name{gcefg}
\alias{gcefg}
\title{Fit Generalized Competing Event Model Based on Fine Gray Regression}
\usage{
gcefg(ostime1, ostime2, ostime3, cod1, cod2, data, covnames, N, M, t)
}
\arguments{
\item{ostime1}{vector of times for event(s) of interest.}

\item{ostime2}{vector of times for competing event(s).}

\item{ostime3}{vector of times for the composute set of all events.}

\item{cod1}{vector with 1 for event(s) pf interest, 2 for competing event(s) and 0 for censored observations.}

\item{cod2}{vector with 1 for the composite set of all events and 0 for censored observations.}

\item{data}{a data frame containing all covariates.}

\item{covnames}{vector of names for all covariates in data.}

\item{N}{the number of bootstrap replicates}

\item{M}{the number of bins for \eqn{\omega} or \eqn{\omega+} plots.}

\item{t}{survival time point for \eqn{\omega} or \eqn{\omega+} plots.}
}
\value{
\item{$coef1}{generalized competing event model coefficients (log (\eqn{\omega} ratio))}
\item{$coef2}{generalized competing event model coefficients (log (\eqn{\omega+} ratio))}
\item{$result1}{result table for generalized competing event model containing exponential of coefficients (\eqn{\omega} ratio) and 95\% confidence intervals}
\item{$result2}{result table for generalized competing event model containing exponential of coefficients (\eqn{\omega+} ratio) and 95\% confidence intervals}
\item{$omegaplot1}{\eqn{\omega} plot for generalized  competing evet model}
\item{$omegaplot2}{\eqn{\omega+} plot for generalized  competing evet model}
\item{$omegaplot3}{plot of \eqn{\omega} vs time}
}
\description{
Fit a generalized competing event model by using Fine Gray
regression model with \code{crr} function in \code{cmprsk} package.
}
\details{
The \strong{gcerisk} package is designed to help investigators optimize risk-stratification methods for competing risks data, such as described in
Carmona R, Gulaya S, Murphy JD, Rose BS, Wu J, Noticewala S, McHale MT, Yashar CM, Vaida F, Mell LK. Validated competing event model for the stage I-II endometrial cancer population.
Int J Radiat Oncol Biol Phys. 2014;89:888-98. Standard risk models typically estimate the effects of one or more covariates on either
a single event of interest (such as overall mortality, or disease recurrence), or a composite set of events (e.g., disease-free survival, which combines events of interest with death from any cause).
This method is inefficient in stratifying patients who may be simultaneously at high risk for the event of interest but low risk for competing events, and who thus stand to gain the most from strategies to modulate the event of interest.
Compared to standard risk models, GCE models better stratify patients at higher (lower) risk for an event of interest and lower (higher) risk of competing events. GCE models focus on differentiating subjects based on
the ratio of the cumulative hazard (or cumulative hazard of the subdistribution) for the event of interest to the cumulative hazard (or cumulative hazard of the subdistribution) for all events (\eqn{\omega}),
and the ratio of the cumulative hazard (or cumulative hazard of the subdistribution) for the event of interest to the cumulative hazard (or cumulative hazard of the subdistribution) for competing events (\eqn{\omega+}).

The \code{gcefg} function produces model estimates and confidence intervals from a generalized competing event model based on the Fine-Gray model for subdistribution hazards. In the subdistribution hazards model, the function H(t)= -log(1-F(t)) represents the cumulative hazard of the subdistribution for the cumulative distribution function F(t).
The model assumes proportional subdistribution hazards for the composite set of events.

The function returns \eqn{\omega} and \eqn{\omega+} ratio estimates for the chosen covariates, with 95\% confidence intervals, and plots \eqn{\omega} and \eqn{\omega+} at time t within M ordered subsets of subjects as a function of increasing risk (based on the linear predictor, i.e. the inner product of a subject's data vector and the coefficient vector).
}
\examples{
# sample data to test
data(Sample)
test <- Sample
d <- trunc(dim(test)[1]*0.1)
set.seed(seed=2015)
s <- sample(dim(test)[1],d,replace = FALSE)
test <- test[s,]
rm(list=setdiff(ls(), "test"))
test <- transform(test, LRF_OR_DF_FLAG = as.numeric(test$LRFFLAG | test$DFFLAG))
test <- transform(test, LRF_OR_DF_MO = pmin(test$LRFMO, test$DFMO))
test <- transform(test, CMFLAG = as.numeric(test$OSFLAG & !test$LRFFLAG & !test$DFFLAG))
test <- transform(test, ACMFLAG = as.numeric(test$LRF_OR_DF_FLAG | test$CMFLAG))
test <- transform(test, ACM_MO = pmin(test$LRF_OR_DF_MO, test$OSMO))

cod1 <- test$ACMFLAG
cod1[test$LRF_OR_DF_FLAG == 1] <- 1
cod1[test$CMFLAG == 1] <- 2
cod2 <- test$ACMFLAG
ostime1 <- test$LRF_OR_DF_MO/30
ostime2 <- test$OSMO/30
ostime3 <- test$ACM_MO/30
covnames <- c("age", "smoke20", "etohheavy", "BMI")

N <- 50
M <- 5
t <- 5

fit <- gcefg(ostime1, ostime2, ostime3, cod1, cod2, test, covnames, N, M, t)
}
\references{
\itemize{
\item Carmona R, Gulaya S, Murphy JD, Rose BS, Wu J, Noticewala S, McHale MT, Yashar CM, Vaida F, Mell LK. (2014) Validated competing event model for the stage I-II endometrial cancer population. Int J Radiat Oncol Biol Phys.89:888-98.
\item Carmona R, Green GB, Zakeri K, Gulaya S, Xu B, Verma R, Williamson C, Rose BS, Murphy JD, Vaida F, Mell LK. (2015) Novel method to stratify elderly patients with head and neck cancer. J Clin Oncol 33 (suppl; abstr 9534).
\item Carmona R, Zakeri K, Green GB, Triplett DP, Murphy JD, Mell LK. (2015) Novel method to stratify elderly patients with prostate cancer. J Clin Oncol 33 (suppl; abstr 9532).
}
}
\author{
Hanjie Shen, Ruben Carmona, Loren Mell
}
