% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gauss_fit.R
\name{plot_gauss}
\alias{plot_gauss}
\title{Plots a peak with the fitted Gaussian curve.}
\usage{
plot_gauss(TIC_df, gauss_return, title = "Peak fit to Gaussian")
}
\arguments{
\item{TIC_df}{a \emph{data.frame} object. Data frame with 4 columns
(Overall Time Index, RT1, RT2, TIC), ideally the output from create_df(), or
the first data frame returned from extract_data(), $TIC_df.}

\item{gauss_return}{a \emph{data.frame} object. The output from guass_fit().
A data frame with two columns, (time, guassfit), the time values around the
peak, and the intensity values fitted to the optimal Gaussian curve.}

\item{title}{a \emph{string} object. Title placed at the top of the plot.}
}
\value{
A \emph{ggplot} object. A plot of points around the peak with a line
plot of the Gaussian curve fit to the peak data.
}
\description{
\code{plot_gauss} Plots a peak with the fitted Gaussian curve.
}
\details{
This function plots the points around the peak in blue dots, with a
line plot of the Gaussian curve fit to the peak data in red, using
\code{\link[ggplot2]{ggplot}} from ggplot2 package
\insertCite{ggplot2}{gcxgclab}.
}
\examples{
file <- system.file("extdata","sample1.cdf",package="gcxgclab")
frame <- extract_data(file,mod_t=.5)
peaks <- top_peaks(frame$TIC_df, 5)
gaussfit <- gauss_fit(frame$TIC_df, peakcoord=c(peaks$'X'[1], peaks$'Y'[1]))
message(paste('Area under curve =',gaussfit[[3]], 'u^2'))
plot_gauss(frame$TIC_df, gaussfit[[1]])

}
\references{
\insertAllCited{}
}
