% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blc_sm.R
\name{preprocess}
\alias{preprocess}
\title{Preprocessing}
\usage{
preprocess(
  filename,
  mod_t = 10,
  shift = 0,
  lambda = 20,
  gamma = 0.5,
  subtract = NULL,
  images = FALSE
)
}
\arguments{
\item{filename}{a \emph{string} object. The file name or path of the cdf
file to be opened.}

\item{mod_t}{a \emph{float} object. The modulation time for the GCxGC sample
analysis.Default is 10.}

\item{shift}{a \emph{float} object. The number of seconds to shift the phase
by. Default is 0 to skip shifting.}

\item{lambda}{a \emph{float} object. A number (parameter in Whittaker
smoothing), suggested between 1 to 10^5. Small lambda is very little
smoothing, large lambda is very smooth. Default is lambda = 20.}

\item{gamma}{a \emph{float} object. Correction factor between 0 and 1. 0
results in almost no values being subtracted to the baseline, 1 results in
almost everything except the peaks to be subtracted to the baseline. Default
is 0.5.}

\item{subtract}{a \emph{data.frame} object. Data frame containing TIC data
from a background sample or blank sample to be subtracted from the sample TIC
data.}

\item{images}{a \emph{boolean} object. An optional input. If TRUE, all images
of preprocessing steps will be displayed. Default is FALSE, no images will be
displayed.}
}
\value{
A \emph{data.frame} object. A list of two data frames. A TIC data
frame and an MS data frame.
}
\description{
\code{preprocess} performs full preprocessing on a data file.
}
\details{
This function performs full preprocessing on a data file. Extracts
data and performs smoothing and baseline correction.
}
\examples{
file <- system.file("extdata","sample1.cdf",package="gcxgclab")
frame <- preprocess(file,mod_t=.5,lambda=10,gamma=0.5,images=TRUE)

}
