% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_peaks.R
\name{top_peaks}
\alias{top_peaks}
\title{Top Peaks}
\usage{
top_peaks(TIC_df, N)
}
\arguments{
\item{TIC_df}{a \emph{data.frame} object. Data frame with 4 columns
(Overall Time Index, RT1, RT2, TIC), ideally the output from create_df(), or
the first data frame returned from extract_data(), $TIC_df.}

\item{N}{\emph{int} object. The number of top peaks to be found in the
sample. N should be an integer >=1. Default suggestion is N = 20.}
}
\value{
A \emph{data.frame} object. A data frame with 4 columns (Time, X, Y,
Peak) with the top N peaks, with their time coordinates.
}
\description{
\code{top_peaks} finds the top N highest peaks.
}
\details{
This function finds the top N peaks in intensity in the sample.
}
\examples{
file1 <- system.file("extdata","sample1.cdf",package="gcxgclab")
frame <- extract_data(file1,mod_t=.5)
peaks <- top_peaks(frame$TIC_df, 5)
plot_peak(peaks, frame, title="Top 20 Peaks")
plot_peakonly(peaks,title="Top 20 Peaks")

}
