% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdal_cmd_builder.R
\name{gdal_cmd_builder}
\alias{gdal_cmd_builder}
\title{gdal_cmd_builder}
\usage{
gdal_cmd_builder(executable, parameter_variables = c(),
  parameter_values = c(), parameter_order = c(), parameter_noflags = c(),
  parameter_doubledash = c(), parameter_noquotes = c(),
  gdal_installation_id = 1)
}
\arguments{
\item{executable}{Character. The GDAL command to use (e.g. "gdal_translate")}

\item{parameter_variables}{List. A list of parameter names, organized by type.}

\item{parameter_values}{List. A list of the parameters names/values.}

\item{parameter_order}{Character. The order of the parameters for the GDAL command.}

\item{parameter_noflags}{Character. Parameters which do not have a flag.}

\item{parameter_doubledash}{Character. Parameters which should have a double dash "--".}

\item{parameter_noquotes}{Character. Parameters which should not be wrapped in quotes (vector parameters only, at present).}

\item{gdal_installation_id}{Numeric. The ID of the GDAL installation to use.  Defaults to 1.}
}
\value{
Formatted GDAL command for use with system() calls.
}
\description{
Helper function for building GDAL commands.
}
\details{
This function takes the executable name (e.g. "gdal_translate"),
a list of parameter names organized by logical, vector,
scalar, character, repeatable, a list of values of these parameters, 
the order they should be used in the GDAL command, and a list of
parameters that should not have a flag, and returns a properly
formatted GDAL command (with the full path-to-executable) that
should work with a system() call.

Sometimes, a user may not want to use the most recent GDAL install
(gdal_installation_id=1), so the gdal_installation_id can be used
to set a different install.  This is often used with gdal_chooseInstallation
if, for instance, the particular GDAL installation required needs
a specific driver that may not be available in all installations.

In general, an end user shouldn't need to use this function -- it
is used by many of the GDAL wrappers within gdalUtils.
}
\examples{
\dontrun{ 
# This builds a gdal_translate command.
executable <- "gdal_translate"

parameter_variables <- list(
			logical = list(
					varnames <- c("strict","unscale","epo",
					"eco","q","sds","stats")),
			vector = list(
					varnames <- c("outsize","scale","srcwin",
					"projwin","a_ullr","gcp")),
			scalar = list(
					varnames <- c("a_nodata")),
			character = list(
					varnames <- c("ot","of","mask","expand","a_srs",
					"src_dataset","dst_dataset")),
			repeatable = list(
					varnames <- c("b","mo","co")))

parameter_order <- c(
			"strict","unscale","epo","eco","q","sds","stats",
			"outsize","scale","srcwin","projwin","a_ullr","gcp",
			"a_nodata",
			"ot","of","mask","expand","a_srs",
			"b","mo","co",
			"src_dataset","dst_dataset")

parameter_noflags <- c("src_dataset","dst_dataset")

# Now assign some parameters:
parameter_values = list(
	src_dataset = "input.tif",
	dst_dataset = "output.envi",
	of = "ENVI",
	strict = TRUE
)

cmd <- gdal_cmd_builder(
			executable=executable,
			parameter_variables=parameter_variables,
			parameter_values=parameter_values,
			parameter_order=parameter_order,
			parameter_noflags=parameter_noflags)

cmd
system(cmd,intern=TRUE) 
}
}
\references{
\url{http://www.gdal.org/gdal_translate.html}
}
\author{
Jonathan A. Greenberg (\email{gdalUtils@estarcion.net})
}
