% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdaladdo.R
\name{gdaladdo}
\alias{gdaladdo}
\title{gdaladdo}
\usage{
gdaladdo(filename, levels, r, b, ro, clean, oo, ignore.full_scan = TRUE,
  verbose = FALSE)
}
\arguments{
\item{filename}{Character. The file to build overviews for (or whose overviews must be removed).}

\item{levels}{Numeric. A list of integral overview levels to build. Ignored with clean=TRUE option.}

\item{r}{Character. ("nearest"|"average"|"gauss"|"cubic"|"average_mp"|"average_magphase"|"mode") Select a resampling algorithm.  Default is "nearest".}

\item{b}{Numeric. (available from GDAL 1.10) Select an input band band for overview generation. Band numbering starts from 1. Multiple -b switches may be used to select a set of input bands to generate overviews.}

\item{ro}{Logical. (available from GDAL 1.6.0) open the dataset in read-only mode, in order to generate external overview (for GeoTIFF especially).}

\item{clean}{Logical. (available from GDAL 1.7.0) remove all overviews.}

\item{oo}{Character. NAME=VALUE. (starting with GDAL 2.0) Dataset open option (format specific)}

\item{ignore.full_scan}{Logical. If FALSE, perform a brute-force scan if other installs are not found.  Default is TRUE.}

\item{verbose}{Logical. Enable verbose execution? Default is FALSE.}
}
\description{
R wrapper for gdaladdo: builds or rebuilds overview images
}
\details{
This is an R wrapper for the 'gdaladdo' function that is part of the 
Geospatial Data Abstraction Library (GDAL).  It follows the parameter naming
conventions of the original function, with some modifications to allow for more R-like
parameters.  For all parameters, the user can use a single character string following,
precisely, the gdalinfo format (\url{http://gdal.org/gdaladdo.html}), or,
in some cases, can use R vectors to achieve the same end.  

This function assumes the user has a working GDAL on their system.  If the 
"gdalUtils_gdalPath" option has been set (usually by gdal_setInstallation),
the GDAL found in that path will be used.  If nothing is found, gdal_setInstallation
will be executed to attempt to find a working GDAL.
}
\examples{
# We'll pre-check to make sure there is a valid GDAL install.
# Note this isn't strictly neccessary, as executing the function will
# force a search for a valid GDAL install.
gdal_setInstallation()
valid_install <- !is.null(getOption("gdalUtils_gdalPath"))
if(valid_install)
{
filename  <- system.file("external/tahoe_highrez.tif", package="gdalUtils")
temp_filename <- paste(tempfile(),".tif",sep="")
file.copy(from=filename,to=temp_filename,overwrite=TRUE)
gdalinfo(filename)
gdaladdo(r="average",temp_filename,levels=c(2,4,8,16),verbose=TRUE)
gdalinfo(temp_filename)
}
}
\references{
\url{http://www.gdal.org/gdaladdo.html}
}
\author{
Jonathan A. Greenberg (\email{gdalUtils@estarcion.net}) (wrapper) and Frank Warmerdam (GDAL lead developer).
}
