% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_bands.R
\name{join_bands}
\alias{join_bands}
\title{Join bands of two identically shaped data cubes}
\usage{
join_bands(cube_list, cube_names = NULL)
}
\arguments{
\item{cube_list}{a list with two or more source data cubes}

\item{cube_names}{list or character vector with optional name prefixes for bands in the output data cube (see Details)}
}
\value{
proxy data cube object
}
\description{
Create a proxy data cube, which joins the bands of two identically shaped data cubes. The resulting cube
will have bands from both input cubes.
}
\details{
The number of provided cube_names must match the number of provided input cubes.
If no cube_names are provided, bands of the output cube will adopt original names from the input cubes (without any prefix). If any two of the input bands have identical names,
prefixes default prefixes ("X1", "X2", ...) will be used.
}
\note{
This function returns a proxy object, i.e., it will not start any computations besides deriving the shape of the result.
}
\examples{
# create image collection from example Landsat data only 
# if not already done in other examples
if (!file.exists(file.path(tempdir(), "L8.db"))) {
  L8_files <- list.files(system.file("L8NY18", package = "gdalcubes"),
                         ".TIF", recursive = TRUE, full.names = TRUE)
  create_image_collection(L8_files, "L8_L1TP", file.path(tempdir(), "L8.db")) 
}

L8.col = image_collection(file.path(tempdir(), "L8.db"))
v = cube_view(extent=list(left=388941.2, right=766552.4,
                          bottom=4345299, top=4744931, t0="2018-01", t1="2018-05"),
                          srs="EPSG:32618", nx = 497, ny=526, dt="P1M")
L8.cube = raster_cube(L8.col, v)
L8.cube.b04 = select_bands(raster_cube(L8.col, v), c("B04"))
L8.cube.b05 = select_bands(raster_cube(L8.col, v), c("B05"))
join_bands(list(L8.cube.b04,L8.cube.b05))
\donttest{
plot(join_bands(list(L8.cube.b04,L8.cube.b05)))
}
}
