% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fillNodata}
\alias{fillNodata}
\title{Fill selected pixels by interpolation from surrounding areas}
\usage{
fillNodata(
  filename,
  band,
  mask_file = "",
  max_dist = 100,
  smooth_iterations = 0L
)
}
\arguments{
\item{filename}{Filename of input raster in which to fill nodata pixels.}

\item{band}{Integer band number to modify in place.}

\item{mask_file}{Optional filename of raster to use as a validity mask
(band 1 is used, zero marks nodata pixels, non-zero marks valid pixels).}

\item{max_dist}{Maximum distance (in pixels) that the algorithm
will search out for values to interpolate (100 pixels by default).}

\item{smooth_iterations}{The number of 3x3 average filter smoothing
iterations to run after the interpolation to dampen artifacts
(0 by default).}
}
\value{
Logical indicating success (invisible \code{TRUE}).
An error is raised if the operation fails.
}
\description{
\code{fillNodata()} is a wrapper for \code{GDALFillNodata()} in the GDAL Algorithms
API. This algorithm will interpolate values for all designated nodata
pixels (pixels having an intrinsic nodata value, or marked by zero-valued
pixels in the optional raster specified in \code{mask_file}). For each nodata
pixel, a four direction conic search is done to find values to interpolate
from (using inverse distance weighting).
Once all values are interpolated, zero or more smoothing iterations
(3x3 average filters on interpolated pixels) are applied to smooth out
artifacts.
}
\note{
The input raster will be modified in place. It should not be open in a
\code{GDALRaster} object while processing with \code{fillNodata()}.
}
\examples{
## fill nodata edge pixels in the elevation raster
elev_file <- system.file("extdata/storml_elev.tif", package="gdalraster")

## get count of nodata
tbl <- buildRAT(elev_file)
head(tbl)
tbl[is.na(tbl$VALUE),]

## make a copy that will be modified
mod_file <- paste0(tempdir(), "/", "storml_elev_fill.tif")
file.copy(elev_file,  mod_file)

fillNodata(mod_file, band=1)

mod_tbl = buildRAT(mod_file)
head(mod_tbl)
mod_tbl[is.na(mod_tbl$VALUE),]
}
