% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{g_envelope}
\alias{g_envelope}
\title{Obtain the bounding envelope for input geometries}
\usage{
g_envelope(geom, quiet = FALSE)
}
\arguments{
\item{geom}{Either a raw vector of WKB or list of raw vectors, or a
character vector containing one or more WKT strings.}

\item{quiet}{Logical value, \code{TRUE} to suppress warnings. Defaults to \code{FALSE}.}
}
\value{
Either a numeric vector of length 4 containing the envelope
\verb{(xmin, xmax, ymin, ymax)}, or a four-column numeric matrix with number of
rows equal to the number of input geometries and column names
\verb{("xmin", "xmax", "ymin", "ymax")}.
}
\description{
\code{g_envelope()} computes and returns the bounding envelope(s) for the input
geometries. Wrapper of \code{OGR_G_GetEnvelope()} in GDAL OGRGeometry.
}
