% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdi.r
\name{fdetect}
\alias{fdetect}
\title{Tool to help determine which threshold value and method to use with measuresil() or cscorr(). The function analyzes all pixels along the edges of the image to determine the background color, to help with deciding on appropriate settings and avoid errors introduced by inappropriate settings}
\usage{
fdetect(image_file, threshold = 0.5, channel = 4, plot = FALSE)
}
\arguments{
\item{image_file}{Image to be read. Images can be jpeg or png files, or a previously read image saved as an object in R.}

\item{threshold}{Reference value for color criterium after which pixels that are part of the silhouette should be differentiated from the background.}

\item{channel}{Color channel to which to apply the threshold criterium. Default is 4 (alpha channel of rgba image). Channel setting needs to be adjusted depending on the color mode of the image used (e.g. there are two channels to choose from in a greyscale image, and 3 in an rgb image).}

\item{plot}{Whether to plot a histogram with the detected color values (if TRUE) or not (if FALSE, default).}
}
\value{
A list()-object containing: $edgetable (a table of the different color values detected and their respective frequencies), $histogram (a histogram-object of the color values), $most_common (the most common color value found), $foreground (a character string, indicating whether the foreground color value is likely "greater" or "less" than the specified threshold), $result (a character string giving a summary of the results)
}
\description{
Tool to help determine which threshold value and method to use with measuresil() or cscorr(). The function analyzes all pixels along the edges of the image to determine the background color, to help with deciding on appropriate settings and avoid errors introduced by inappropriate settings
}
\examples{
fdir <- system.file(package="gdi")
fdetect(file.path(fdir,"exdata","lat.png"))
}
