% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Summary-methods.R
\name{Summary-methods}
\alias{Summary-methods}
\alias{Summary,TransitionLayer-method}
\alias{Summary,TransitionStack-method}
\alias{sum,TransitionStack-method}
\alias{mean,TransitionStack-method}
\alias{summary,TransitionLayer-method}
\alias{summary,TransitionStack-method}
\title{Summary methods}
\usage{
\S4method{Summary}{TransitionStack}(x, ..., na.rm = FALSE)
}
\arguments{
\item{x}{objects}

\item{...}{further arguments passes to or from methods}

\item{na.rm}{logical, should missing values be removed?}
}
\value{
a TransitionLayer
}
\description{
The following summary methods are available: mean,
 Median, max, min, range, prod, sum, any, all
}
\note{
These methods compute a summary statistic based on cell values of
 layers in a TransitionStack. The result of these methods is always a
 single TransitionLayer.
}
\examples{
#Create a new raster and set all its values to unity.
raster <- raster(nrows=18, ncols=36)
raster <- setValues(raster,rep(1,ncell(raster)))

#Create a Transition object from the raster
tr <- transition(raster,mean,4)

trS <- stack(tr, tr*2)

#Apply a Summary method
trSum <- sum(trS)

#plot(raster(trMean))
}
\author{
Jacob van Etten
}
