% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fontconfig.R
\name{match_family}
\alias{match_family}
\alias{match_font}
\title{Find best family match with fontconfig}
\usage{
match_family(font = "sans", bold = TRUE, italic = TRUE,
  debug = NULL)

match_font(font = "sans", bold = FALSE, italic = FALSE,
  debug = NULL)
}
\arguments{
\item{font}{family or face to match.}

\item{bold}{Wheter to match a font featuring a \code{bold} face.}

\item{italic}{Wheter to match a font featuring an \code{italic} face.}

\item{debug}{Flag for debugging FontConfig. Can be one of
\code{"config"}, \code{"match"}. Alternatively, can be an integer
that is directly used as environment variable for \code{FC_DEBUG}
(see FontConfig documentation).}
}
\description{
\code{match_family()} returns the best font family match for the
fontconfig pattern constructed from the \code{bold} and
\code{italic} arguments. The default pattern is bold italic to make
sure the matched font has enough features to be used in R graphics
(plain, bold, italic, bold italic). \code{match_font()} returns the
font file from the best family match, along with some metada in the
attributes.
}
\details{
Fontconfig matching is controlled via the \code{fonts.conf}
file. Use \code{debug = "config"} to make sure what configuration
file it is currently using (there can be several installations on
one system, especially on Macs). See
\url{https://www.freedesktop.org/software/fontconfig/fontconfig-user.html}
for more information about debugging flags.
}
\examples{
\dontrun{
# The first run can be slow when font caches are missing
# as font files are then being scanned to build those font caches.
match_family("sans")
match_family("serif", bold = FALSE, italic = TRUE)

match_font("Helvetica", bold = FALSE, italic = TRUE)
match_font("Helvetica", debug = "config")
}
}
