% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opgd.R
\name{opgd}
\alias{opgd}
\title{optimal parameters-based geographical detector(OPGD) model}
\usage{
opgd(
  formula,
  data,
  discvar = NULL,
  discnum = 3:22,
  discmethod = c("sd", "equal", "geometric", "quantile", "natural"),
  cores = 1,
  type = "factor",
  alpha = 0.95,
  ...
)
}
\arguments{
\item{formula}{A formula of OPGD model.}

\item{data}{A data.frame, tibble or sf object of observation data.}

\item{discvar}{Name of continuous variable columns that need to be discretized. Noted that
when \code{formula} has \code{discvar}, \code{data} must have these columns. By default, all independent
variables are used as \code{discvar}.}

\item{discnum}{(optional) A vector of number of classes for discretization. Default is \code{3:22}.}

\item{discmethod}{(optional) A vector of methods for discretization, default is using
\code{c("sd","equal","geometric","quantile","natural")} by invoking \code{sdsfun}.}

\item{cores}{(optional) Positive integer (default is 1). When cores are greater than 1, use
multi-core parallel computing.}

\item{type}{(optional) The type of geographical detector,which must be \code{factor}(default),
\code{interaction}, \code{risk}, \code{ecological}. You can run one or more types at one time.}

\item{alpha}{(optional) Specifies the size of confidence level.Default is \code{0.95}.}

\item{...}{(optional) Other arguments passed to \code{gd_bestunidisc()}. A useful parameter is \code{seed},
which is used to set the random number seed.}
}
\value{
A list.
\describe{
\item{\code{factor}}{the result of factor detector}
\item{\code{interaction}}{the result of interaction detector}
\item{\code{risk}}{the result of risk detector}
\item{\code{ecological}}{the result of ecological detector}
}
}
\description{
Function for optimal parameters-based geographical detector(OPGD) model.
}
\examples{
data('sim')
opgd(y ~ xa + xb + xc, data = sim,
     discvar = paste0('x',letters[1:3]),
     discnum = 3:6)

}
\references{
Song, Y., Wang, J., Ge, Y. & Xu, C. (2020) An optimal parameters-based geographical detector
model enhances geographic characteristics of explanatory variables for spatial heterogeneity
analysis: Cases with different types of spatial data, GIScience & Remote Sensing, 57(5), 593-610.
doi: 10.1080/15481603.2020.1760434.
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
