% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qpgee_tune.R
\name{qpgee_tune}
\alias{qpgee_tune}
\title{Quantile Penalized Generalized Estimating Equations with Auto Selected Penalty level}
\usage{
qpgee_tune(
  x,
  y,
  tau = 0.5,
  method = "HBIC",
  ncore = 1,
  nk = rep(1, length(y)),
  worktype = "CS",
  lambda = NULL,
  f0 = NULL,
  betaint = NULL,
  max_it = 100,
  cutoff = 10^-1
)
}
\arguments{
\item{x}{A matrix of predictors.}

\item{y}{A numeric vector of response variables.}

\item{tau}{The quantile to be estimated (default is 0.5, the median).}

\item{method}{The criterion to select level of penalty. Currently it only
supports "HBIC".}

\item{ncore}{A numeric value specifying how many core to use.}

\item{nk}{A numeric vector indicating the number of observations per subject.}

\item{worktype}{A string specifying the working correlation structure.
Options include "CS" (Compound Symmetry), "AR" (Autoregressive),
"Tri" (Tri-diagonal), and "Ind" (Independent).}

\item{lambda}{A vector of penalty parameter for regularization. If not provided,
a grid will be provided by this function.}

\item{f0}{estimated conditional error distributions.}

\item{betaint}{Initial values for the beta coefficients. If NULL,
non-longitudinal quantile regression is used for initialization.}

\item{max_it}{Maximum number of iterations (default is 100).}

\item{cutoff}{Threshold for coefficient shrinkage (default is 0.1).}
}
\value{
A list containing the following components:
          \item{beta}{Estimated beta coefficients.}
          \item{g}{Fitted values of the linear predictor.}
          \item{R}{Estimated working correlation matrix.}
          \item{X_selected}{Indices of selected predictors.}
          \item{mcl}{Mean check loss.}
          \item{hbic}{Hannan-Quinn Information Criterion value.}
          \item{converge}{Boolean indicating whether the algorithm converged.}
}
\description{
This function automatically select the penalty level by going through a list
of lambdas, and select the best level of penalty with high-dimensional BIC
(HBIC) or cross-validation (CV).
}
\examples{
# Example usage:

sim_data <- generateData(n_sub = 20, n_obs = rep(10, 20),  p = 20,
                         beta0 = rep(1,5), rho = 0.1, type = "ar",
                          dis = "normal", ka = 1)

X=sim_data$X
y=sim_data$y

#fit qpgee with auto selected lambda
qpgee.fit = qpgee_tune(X,y,tau=0.5,nk=rep(10, 20),ncore=1)
qpgee.fit$beta

}
