/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.graph.MultiGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections15.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetHypergraph<V, H>
implements Hypergraph<V, H>,
MultiGraph<V, H>,
Serializable {
    protected Map<V, Set<H>> vertices = new HashMap<V, Set<H>>();
    protected Map<H, Set<V>> edges = new HashMap<H, Set<V>>();

    public static <V, H> Factory<Hypergraph<V, H>> getFactory() {
        return new Factory<Hypergraph<V, H>>(){

            @Override
            public Hypergraph<V, H> create() {
                return new SetHypergraph();
            }
        };
    }

    @Override
    public boolean addEdge(H hyperedge, Collection<? extends V> to_attach) {
        if (hyperedge == null) {
            throw new IllegalArgumentException("input hyperedge may not be null");
        }
        if (to_attach == null) {
            throw new IllegalArgumentException("endpoints may not be null");
        }
        if (to_attach.contains(null)) {
            throw new IllegalArgumentException("cannot add an edge with a null endpoint");
        }
        HashSet<? extends V> new_endpoints = new HashSet<V>(to_attach);
        if (this.edges.containsKey(hyperedge)) {
            Collection attached = this.edges.get(hyperedge);
            if (!((Object)attached).equals(new_endpoints)) {
                throw new IllegalArgumentException("Edge " + hyperedge + " exists in this graph with endpoints " + attached);
            }
            return false;
        }
        this.edges.put(hyperedge, new_endpoints);
        for (V v : to_attach) {
            this.addVertex(v);
            this.vertices.get(v).add(hyperedge);
        }
        return true;
    }

    @Override
    public boolean addEdge(H hyperedge, Collection<? extends V> to_attach, EdgeType edge_type) {
        if (edge_type != EdgeType.UNDIRECTED) {
            throw new IllegalArgumentException("Edge type for this implementation must be EdgeType.HYPER, not " + (Object)((Object)edge_type));
        }
        return this.addEdge(hyperedge, to_attach);
    }

    @Override
    public EdgeType getEdgeType(H edge) {
        if (this.containsEdge(edge)) {
            return EdgeType.UNDIRECTED;
        }
        return null;
    }

    @Override
    public boolean containsVertex(V vertex) {
        return this.vertices.keySet().contains(vertex);
    }

    @Override
    public boolean containsEdge(H edge) {
        return this.edges.keySet().contains(edge);
    }

    @Override
    public Collection<H> getEdges() {
        return this.edges.keySet();
    }

    @Override
    public Collection<V> getVertices() {
        return this.vertices.keySet();
    }

    @Override
    public int getEdgeCount() {
        return this.edges.size();
    }

    @Override
    public int getVertexCount() {
        return this.vertices.size();
    }

    @Override
    public Collection<V> getNeighbors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        HashSet neighbors = new HashSet();
        for (H hyperedge : this.vertices.get(vertex)) {
            neighbors.addAll(this.edges.get(hyperedge));
        }
        return neighbors;
    }

    @Override
    public Collection<H> getIncidentEdges(V vertex) {
        return this.vertices.get(vertex);
    }

    @Override
    public Collection<V> getIncidentVertices(H edge) {
        return this.edges.get(edge);
    }

    @Override
    public H findEdge(V v1, V v2) {
        if (!this.containsVertex(v1) || !this.containsVertex(v2)) {
            return null;
        }
        for (H h : this.getIncidentEdges(v1)) {
            if (!this.isIncident(v2, h)) continue;
            return h;
        }
        return null;
    }

    @Override
    public Collection<H> findEdgeSet(V v1, V v2) {
        if (!this.containsVertex(v1) || !this.containsVertex(v2)) {
            return null;
        }
        ArrayList<H> edges = new ArrayList<H>();
        for (H h : this.getIncidentEdges(v1)) {
            if (!this.isIncident(v2, h)) continue;
            edges.add(h);
        }
        return Collections.unmodifiableCollection(edges);
    }

    @Override
    public boolean addVertex(V vertex) {
        if (vertex == null) {
            throw new IllegalArgumentException("cannot add a null vertex");
        }
        if (this.containsVertex(vertex)) {
            return false;
        }
        this.vertices.put(vertex, (Set<H>)new HashSet());
        return true;
    }

    @Override
    public boolean removeVertex(V vertex) {
        if (!this.containsVertex(vertex)) {
            return false;
        }
        for (H hyperedge : this.vertices.get(vertex)) {
            this.edges.get(hyperedge).remove(vertex);
        }
        this.vertices.remove(vertex);
        return true;
    }

    @Override
    public boolean removeEdge(H hyperedge) {
        if (!this.containsEdge(hyperedge)) {
            return false;
        }
        for (V vertex : this.edges.get(hyperedge)) {
            this.vertices.get(vertex).remove(hyperedge);
        }
        this.edges.remove(hyperedge);
        return true;
    }

    @Override
    public boolean isNeighbor(V v1, V v2) {
        if (!this.containsVertex(v1) || !this.containsVertex(v2)) {
            return false;
        }
        if (this.vertices.get(v2).isEmpty()) {
            return false;
        }
        for (H hyperedge : this.vertices.get(v1)) {
            if (!this.edges.get(hyperedge).contains(v2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isIncident(V vertex, H edge) {
        if (!this.containsVertex(vertex) || !this.containsEdge(edge)) {
            return false;
        }
        return this.vertices.get(vertex).contains(edge);
    }

    @Override
    public int degree(V vertex) {
        if (!this.containsVertex(vertex)) {
            return 0;
        }
        return this.vertices.get(vertex).size();
    }

    @Override
    public int getNeighborCount(V vertex) {
        if (!this.containsVertex(vertex)) {
            return 0;
        }
        return this.getNeighbors(vertex).size();
    }

    @Override
    public int getIncidentCount(H edge) {
        if (!this.containsEdge(edge)) {
            return 0;
        }
        return this.edges.get(edge).size();
    }

    @Override
    public int getEdgeCount(EdgeType edge_type) {
        if (edge_type == EdgeType.UNDIRECTED) {
            return this.edges.size();
        }
        return 0;
    }

    @Override
    public Collection<H> getEdges(EdgeType edge_type) {
        if (edge_type == EdgeType.UNDIRECTED) {
            return this.edges.keySet();
        }
        return null;
    }

    @Override
    public EdgeType getDefaultEdgeType() {
        return EdgeType.UNDIRECTED;
    }

    @Override
    public Collection<H> getInEdges(V vertex) {
        return this.getIncidentEdges(vertex);
    }

    @Override
    public Collection<H> getOutEdges(V vertex) {
        return this.getIncidentEdges(vertex);
    }

    @Override
    public int inDegree(V vertex) {
        return this.degree(vertex);
    }

    @Override
    public int outDegree(V vertex) {
        return this.degree(vertex);
    }

    @Override
    public V getDest(H directed_edge) {
        return null;
    }

    @Override
    public V getSource(H directed_edge) {
        return null;
    }

    @Override
    public Collection<V> getPredecessors(V vertex) {
        return this.getNeighbors(vertex);
    }

    @Override
    public Collection<V> getSuccessors(V vertex) {
        return this.getNeighbors(vertex);
    }
}

