/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.TunablePerturber;
import java.util.Random;

public class GroupedSDPerturber
implements TunablePerturber {
    private int[][] expandmat;
    double[] mss;
    double scale;
    int[][] translator;
    int[][] mutrans;
    static Random rand = new Random(System.currentTimeMillis());

    public GroupedSDPerturber(int[][] expandmat, double[] mss) {
        int i;
        this.expandmat = expandmat;
        this.mss = mss;
        int n2 = 1 + GroupedSDPerturber.max(expandmat[2]);
        int n0 = 1 + GroupedSDPerturber.max(expandmat[0]);
        int[][] mat = new int[n2][n0];
        int[][] mumat = new int[n2][n0];
        for (i = 0; i < n2; ++i) {
            for (int j = 0; j < n0; ++j) {
                mat[i][j] = 0;
            }
        }
        for (i = 0; i < expandmat[2].length; ++i) {
            mat[expandmat[2][i]][expandmat[0][i]] = 1;
            mumat[expandmat[2][i]][expandmat[0][i]] = expandmat[1][i];
        }
        this.translator = new int[n2][];
        this.mutrans = new int[n2][];
        for (i = 0; i < n2; ++i) {
            this.translator[i] = new int[this.sum(mat[i])];
            this.mutrans[i] = new int[this.translator[i].length];
            int k = 0;
            for (int j = 0; j < n0; ++j) {
                if (mat[i][j] <= 0) continue;
                this.translator[i][k] = j;
                this.mutrans[i][k++] = mumat[i][j];
            }
        }
    }

    public static int max(int[] t) {
        int maximum = t[0];
        for (int i = 1; i < t.length; ++i) {
            if (t[i] <= maximum) continue;
            maximum = t[i];
        }
        return maximum;
    }

    int sum(int[] vec) {
        int out = 0;
        for (int i = 0; i < vec.length; ++i) {
            out += vec[i];
        }
        return out;
    }

    public void perturb(double[][] candarray, int whoseTurn) {
        double temp = Math.exp(this.mss[whoseTurn] * rand.nextGaussian());
        this.scale = Math.pow(temp, 1.0 + (double)this.translator[whoseTurn].length);
        double[] dArray = candarray[2];
        int n = whoseTurn;
        dArray[n] = dArray[n] * temp;
        for (int i = 0; i < this.translator[whoseTurn].length; ++i) {
            double mu = candarray[1][this.mutrans[whoseTurn][i]];
            candarray[0][this.translator[whoseTurn][i]] = mu + temp * (candarray[0][this.translator[whoseTurn][i]] - mu);
        }
    }

    public int numTurns() {
        return this.mss.length;
    }

    public double jacobian() {
        return this.scale;
    }

    public double[] getStepSizes() {
        double[] tem = new double[this.mss.length];
        System.arraycopy(this.mss, 0, tem, 0, this.mss.length);
        return tem;
    }

    public void setStepSize(double s, int i) {
        this.mss[i] = s;
    }

    public void setStepSizes(double[] s) {
        System.arraycopy(s, 0, this.mss, 0, s.length);
    }
}

