/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections15.BidiMap;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.bidimap.DualHashBidiMap;
import org.apache.commons.collections15.bidimap.UnmodifiableBidiMap;
import org.drugis.common.EqualsUtil;
import org.drugis.mtc.data.DataType;
import org.drugis.mtc.model.Measurement;
import org.drugis.mtc.model.Network;
import org.drugis.mtc.model.Study;
import org.drugis.mtc.model.Treatment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkBuilder<TreatmentType> {
    private static final Pattern s_treatmentIdPattern = Pattern.compile("^[A-Za-z0-9_]+$");
    private BidiMap<TreatmentType, Treatment> d_treatmentMap = new DualHashBidiMap<TreatmentType, Treatment>();
    private Map<MKey, Measurement> d_measurementMap = new HashMap<MKey, Measurement>();
    private Transformer<TreatmentType, String> d_treatmentToIdString;
    private Transformer<TreatmentType, String> d_treatmentToDescription;
    private DataType d_dataType;

    public NetworkBuilder(DataType type) {
        this(new ToStringTransformer(), new ToStringTransformer(), type);
    }

    public NetworkBuilder(Transformer<TreatmentType, String> treatmentToIdString, Transformer<TreatmentType, String> treatmentToDescription, DataType type) {
        this.d_treatmentToIdString = treatmentToIdString;
        this.d_treatmentToDescription = treatmentToDescription;
        this.d_dataType = type;
    }

    public Network buildNetwork() {
        Network network = new Network();
        network.setType(this.d_dataType);
        network.getTreatments().addAll(this.getTreatments());
        network.getStudies().addAll(this.getStudies());
        return network;
    }

    public BidiMap<TreatmentType, Treatment> getTreatmentMap() {
        return UnmodifiableBidiMap.decorate(this.d_treatmentMap);
    }

    protected void add(String studyId, Treatment t, Measurement measurement) {
        MKey key = new MKey(studyId, t);
        if (this.d_measurementMap.containsKey(key)) {
            throw new IllegalArgumentException("Study/Treatment combination already mapped.");
        }
        this.d_measurementMap.put(key, measurement);
    }

    protected Treatment makeTreatment(TreatmentType id) {
        if (!this.d_treatmentMap.containsKey(id)) {
            this.d_treatmentMap.put(id, new Treatment(this.createId(id), this.createDescription(id)));
        }
        return (Treatment)this.d_treatmentMap.get(id);
    }

    private String createId(TreatmentType id) {
        String transformed = this.d_treatmentToIdString.transform(id);
        Matcher matcher = s_treatmentIdPattern.matcher(transformed);
        if (matcher.matches()) {
            return transformed;
        }
        throw new IllegalArgumentException("Illegal Treatment id: " + transformed);
    }

    private String createDescription(TreatmentType id) {
        return this.d_treatmentToDescription.transform(id);
    }

    private Set<Study> getStudies() {
        HashSet<String> ids = new HashSet<String>();
        for (MKey key : this.d_measurementMap.keySet()) {
            ids.add(key.studyId);
        }
        HashSet<Study> studies = new HashSet<Study>();
        for (String id : ids) {
            studies.add(this.getStudy(id));
        }
        return studies;
    }

    private Study getStudy(String id) {
        HashMap<Treatment, Measurement> measurements = new HashMap<Treatment, Measurement>();
        for (MKey key : this.d_measurementMap.keySet()) {
            if (!key.studyId.equals(id)) continue;
            measurements.put(key.treatment, this.d_measurementMap.get(key));
        }
        Study study = new Study(id);
        study.getMeasurements().addAll(measurements.values());
        return study;
    }

    private Collection<Treatment> getTreatments() {
        return this.d_treatmentMap.values();
    }

    private static class MKey {
        public final String studyId;
        public final Treatment treatment;

        public MKey(String studyId, Treatment treatment) {
            this.studyId = studyId;
            this.treatment = treatment;
        }

        public boolean equals(Object o) {
            if (o != null && o instanceof MKey) {
                MKey other = (MKey)o;
                return EqualsUtil.equal(this.studyId, other.studyId) && EqualsUtil.equal(this.treatment, other.treatment);
            }
            return false;
        }

        public int hashCode() {
            return this.studyId.hashCode() * 31 + this.treatment.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TreatmentDescriptionTransformer
    implements Transformer<Treatment, String> {
        @Override
        public String transform(Treatment input) {
            return input.getDescription();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TreatmentIdTransformer
    implements Transformer<Treatment, String> {
        @Override
        public String transform(Treatment input) {
            return input.getId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ToStringTransformer<T>
    implements Transformer<T, String> {
        @Override
        public String transform(T input) {
            return input.toString();
        }
    }
}

