/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.function;

import org.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.util.FastMath;

public class Power
implements DifferentiableUnivariateFunction {
    private final double p;

    public Power(double p) {
        this.p = p;
    }

    public double value(double x) {
        return FastMath.pow(x, this.p);
    }

    public UnivariateFunction derivative() {
        return new UnivariateFunction(){

            public double value(double x) {
                return Power.this.p * FastMath.pow(x, Power.this.p - 1.0);
            }
        };
    }
}

