/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.beans;

import com.jgoodies.binding.list.ObservableList;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.event.ListDataListener;
import org.drugis.common.event.ListDataListenerManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedSetModel<E>
extends AbstractList<E>
implements ObservableList<E> {
    private final SortedSet<E> d_set;
    private final ListDataListenerManager d_listenerManager = new ListDataListenerManager(this);

    public SortedSetModel() {
        this.d_set = new TreeSet();
    }

    public SortedSetModel(Comparator<? super E> comparator) {
        this.d_set = new TreeSet<E>(comparator);
    }

    public SortedSetModel(Collection<? extends E> c) {
        this.d_set = new TreeSet<E>(c);
    }

    @Override
    public int size() {
        return this.d_set.size();
    }

    @Override
    public E get(int index) {
        int i = 0;
        for (Object e : this.d_set) {
            if (i == index) {
                return e;
            }
            ++i;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void add(int index, E element) {
        if (!this.d_set.contains(element)) {
            this.d_set.add(element);
            int idx = this.indexOf(element);
            this.d_listenerManager.fireIntervalAdded(idx, idx);
        }
    }

    @Override
    public E remove(int index) {
        if (index >= 0 && index < this.size()) {
            E e = this.get(index);
            this.d_set.remove(e);
            this.d_listenerManager.fireIntervalRemoved(index, index);
            return e;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public int getSize() {
        return this.size();
    }

    public Object getElementAt(int index) {
        return this.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.d_listenerManager.addListDataListener(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.d_listenerManager.removeListDataListener(l);
    }

    public SortedSet<E> getSet() {
        return new TreeSet<E>(this.d_set);
    }
}

