% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parcor_ijkOLD.R
\name{parcor_ijkOLD}
\alias{parcor_ijkOLD}
\title{Generalized partial correlation coefficient between Xi and Xj after removing the
effect of all others. (older version, deprecated)}
\usage{
parcor_ijkOLD(x, i, j)
}
\arguments{
\item{x}{{Input a p by p matrix R* of generalized correlation coefficients.}}

\item{i}{{A column number identifying the first variable.}}

\item{j}{{A column number identifying the second variable.}}
}
\value{
\item{ouij}{Partial correlation Xi with Xj (=cause) after removing all other X's}
\item{ouji}{Partial correlation Xj with Xi (=cause) after removing all other X's}
\item{myk}{A list of column numbers whose effect has been removed}
}
\description{
This function uses a generalized correlation matrix R* as input to compute
generalized partial correlations between \eqn{X_i} and \eqn{X_j}
where j can be any one of the remaining
variables. Computation removes the effect of all other variables in the matrix.
The user is encouraged to remove all known irrelevant rows and columns 
from the R* matrix before submitting it to this function.
}
\note{
This function calls \code{\link{minor}}, and \code{\link{cofactor}} and is called 
  by \code{parcor_ridge}.
}
\examples{

\dontrun{
set.seed(34);x=matrix(sample(1:600)[1:99],ncol=3)
colnames(x)=c('V1', 'v2', 'V3')
gm1=gmcmtx0(x)
parcor_ijkOLD(gm1, 2,3)
}#' 
}
