% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abs_res.R
\name{abs_res}
\alias{abs_res}
\title{Absolute residuals of kernel regression of x on y.}
\usage{
abs_res(x, y)
}
\arguments{
\item{x}{{vector of data on the dependent variable}}

\item{y}{{vector of data on the regressor}}
}
\value{
absolute values of kernel regression residuals are returned.
}
\description{
This internal function calls the \code{kern} function to implement kernel regression
with the option \code{residuals=TRUE} and returns absolute residuals.
}
\details{
The first argument is assumed to be the dependent variable.  If
\code{abs_res(x,y)} is used, you are regressing x on y (not the usual y on
x)
}
\note{
This function is intended for internal use.
}
\examples{
\dontrun{
set.seed(330)
x=sample(20:50)
y=sample(20:50)
abs_res(x,y)
}
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
\concept{kernel regression residuals}
